/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.implementations.items.IBiometricCard;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

class BiometricCardBakedModel
implements class_1087,
FabricBakedModel {
    private final class_1087 baseModel;
    private final class_1058 texture;

    BiometricCardBakedModel(class_1087 baseModel, class_1058 texture) {
        this.baseModel = baseModel;
        this.texture = texture;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
        context.fallbackConsumer().accept(this.baseModel);
        int hash = BiometricCardBakedModel.getHash(stack);
        this.emitColorCode(context.getEmitter(), hash);
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, Random rand) {
        return this.baseModel.method_4707(state, side, rand);
    }

    private void emitColorCode(QuadEmitter emitter, int hash) {
        CubeBuilder builder = new CubeBuilder(emitter);
        builder.setTexture(this.texture);
        AEColor col = AEColor.values()[Math.abs(3 + hash) % AEColor.values().length];
        if (hash == 0) {
            col = AEColor.BLACK;
        }
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 6; ++y) {
                boolean isLit;
                if (x == 0 || y == 0 || x == 7 || y == 5) {
                    isLit = false;
                } else {
                    boolean bl = isLit = (hash & 1 << x) != 0 || (hash & 1 << y) != 0;
                }
                if (isLit) {
                    builder.setColorRGB(col.mediumVariant);
                } else {
                    float scale = 0.0011764707f;
                    builder.setColorRGB((float)(col.blackVariant >> 16 & 0xFF) * 0.0011764707f, (float)(col.blackVariant >> 8 & 0xFF) * 0.0011764707f, (float)(col.blackVariant & 0xFF) * 0.0011764707f);
                }
                builder.addCube(4 + x, 6 + y, 7.5f, 4 + x + 1, 6 + y + 1, 8.5f);
            }
        }
    }

    public boolean method_4708() {
        return this.baseModel.method_4708();
    }

    public boolean method_4712() {
        return this.baseModel.method_4712();
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return this.baseModel.method_4713();
    }

    public class_1058 method_4711() {
        return this.baseModel.method_4711();
    }

    public class_809 method_4709() {
        return this.baseModel.method_4709();
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    private static int getHash(class_1799 stack) {
        GameProfile gp;
        String username = "";
        if (stack.method_7909() instanceof IBiometricCard && (gp = ((IBiometricCard)stack.method_7909()).getProfile(stack)) != null) {
            username = gp.getId() != null ? gp.getId().toString() : gp.getName();
        }
        return !username.isEmpty() ? username.hashCode() : 0;
    }
}

