/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;

class MemoryCardBakedModel
extends ForwardingBakedModel
implements FabricBakedModel {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};
    private final class_1058 texture;

    public MemoryCardBakedModel(class_1087 baseModel, class_1058 texture) {
        this.wrapped = baseModel;
        this.texture = texture;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
        context.fallbackConsumer().accept(this.wrapped);
        AEColor[] colorCode = MemoryCardBakedModel.getColorCode(stack);
        CubeBuilder builder = new CubeBuilder(context.getEmitter());
        builder.setTexture(this.texture);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 2; ++y) {
                AEColor color = colorCode[x + y * 4];
                builder.setColorRGB(color.mediumVariant);
                builder.addCube(7 + x, 8 + (1 - y), 7.5f, 7 + x + 1, 8 + (1 - y) + 1, 8.5f);
            }
        }
    }

    private static AEColor[] getColorCode(class_1799 stack) {
        if (stack.method_7909() instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)stack.method_7909();
            return memoryCard.getColorCode(stack);
        }
        return DEFAULT_COLOR_CODE;
    }
}

