/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.block.storage.DriveSlotsState;
import appeng.client.render.BakedModelUnwrapper;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.DriveBakedModel;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.core.Api;
import appeng.tile.storage.ChestBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_777;
import net.minecraft.class_778;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class ChestTileEntityRenderer
extends class_827<ChestBlockEntity> {
    private final class_1092 modelManager;
    private final class_778 blockRenderer;

    public ChestTileEntityRenderer(class_824 renderDispatcher) {
        super(renderDispatcher);
        class_310 client = class_310.method_1551();
        this.modelManager = client.method_1554();
        this.blockRenderer = client.method_1541().method_3350();
    }

    public void render(ChestBlockEntity chest, float partialTicks, class_4587 matrices, class_4597 buffers, int combinedLight, int combinedOverlay) {
        class_1937 world = chest.method_10997();
        if (world == null) {
            return;
        }
        DriveSlotsState driveSlotState = DriveSlotsState.fromChestOrDrive(chest);
        class_1792 cellItem = driveSlotState.getCell(0);
        if (cellItem == null || cellItem == class_1802.field_8162) {
            return;
        }
        DriveBakedModel driveModel = this.getDriveModel();
        if (driveModel == null) {
            return;
        }
        class_1087 cellModel = driveModel.getCellChassisModel(cellItem);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        FacingToRotation rotation = FacingToRotation.get(chest.getForward(), chest.getUp());
        rotation.push(matrices);
        matrices.method_22904(-0.5, -0.5, -0.5);
        matrices.method_22904(0.3125, 0.25, 0.0);
        class_4588 buffer = buffers.getBuffer(class_1921.method_23581());
        FaceRotatingModel rotatedModel = new FaceRotatingModel(cellModel, rotation);
        this.blockRenderer.method_3374((class_1920)world, (class_1087)rotatedModel, chest.method_11010(), chest.method_11016(), matrices, buffer, false, new Random(), 0L, combinedOverlay);
        class_4588 ledBuffer = buffers.getBuffer(CellLedRenderer.RENDER_LAYER);
        CellLedRenderer.renderLed(chest, 0, ledBuffer, matrices, partialTicks);
        matrices.method_22909();
    }

    private DriveBakedModel getDriveModel() {
        class_1087 driveModel = this.modelManager.method_4743().method_3335(Api.instance().definitions().blocks().drive().block().method_9564());
        return BakedModelUnwrapper.unwrap(driveModel, DriveBakedModel.class);
    }

    private static class FaceRotatingModel
    extends ForwardingBakedModel {
        private final FacingToRotation r;

        protected FaceRotatingModel(class_1087 base, FacingToRotation r) {
            this.wrapped = base;
            this.r = r;
        }

        @Nonnull
        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, @Nonnull Random rand) {
            if (side != null) {
                side = this.r.resultingRotate(side);
            }
            ArrayList<class_777> quads = new ArrayList<class_777>(super.method_4707(state, side, rand));
            for (int i = 0; i < quads.size(); ++i) {
                class_777 quad = (class_777)quads.get(i);
                quads.set(i, new class_777(quad.method_3357(), quad.method_3359(), this.r.rotate(quad.method_3358()), null, quad.method_24874()));
            }
            return quads;
        }
    }
}

