/*
 * Decompiled with CFR 0.152.
 */
package appeng.container;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.compat.FixedInventoryVanillaWrapper;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.me.SlotME;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.guisync.SyncData;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.CraftingMatrixSlot;
import appeng.container.slot.CraftingTermSlot;
import appeng.container.slot.DisabledSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.InaccessibleSlot;
import appeng.container.slot.PlayerHotBarSlot;
import appeng.container.slot.PlayerInvSlot;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.core.sync.packets.TargetItemStackPacket;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.PlayerSource;
import appeng.mixins.ScreenHandlerListeners;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class AEBaseContainer
extends class_1703 {
    private final class_1661 invPlayer;
    private final IActionSource mySrc;
    private final HashSet<Integer> locked = new HashSet();
    private final class_2586 tileEntity;
    private final IPart part;
    private final IGuiItemObject obj;
    private final HashMap<Integer, SyncData> syncData = new HashMap();
    private boolean isContainerValid = true;
    private ContainerLocator locator;
    private IMEInventoryHandler<IAEItemStack> cellInv;
    private IEnergySource powerSrc;
    private int ticksSinceCheck = 900;
    private IAEItemStack clientRequestedTargetItem = null;

    public AEBaseContainer(class_3917<?> containerType, int id, class_1661 ip, class_2586 myTile, IPart myPart) {
        this(containerType, id, ip, myTile, myPart, null);
    }

    public AEBaseContainer(class_3917<?> containerType, int id, class_1661 ip, class_2586 myTile, IPart myPart, IGuiItemObject gio) {
        super(containerType, id);
        this.invPlayer = ip;
        this.tileEntity = myTile;
        this.part = myPart;
        this.obj = gio;
        this.mySrc = new PlayerSource(ip.field_7546, this.getActionHost());
        this.prepareSync();
    }

    public AEBaseContainer(class_3917<?> containerType, int id, class_1661 ip, Object anchor) {
        super(containerType, id);
        this.invPlayer = ip;
        this.tileEntity = anchor instanceof class_2586 ? (class_2586)anchor : null;
        this.part = anchor instanceof IPart ? (IPart)anchor : null;
        IGuiItemObject iGuiItemObject = this.obj = anchor instanceof IGuiItemObject ? (IGuiItemObject)anchor : null;
        if (this.tileEntity == null && this.part == null && this.obj == null) {
            throw new IllegalArgumentException("Must have a valid anchor, instead " + anchor + " in " + ip);
        }
        this.mySrc = new PlayerSource(ip.field_7546, this.getActionHost());
        this.prepareSync();
    }

    protected IActionHost getActionHost() {
        if (this.obj instanceof IActionHost) {
            return (IActionHost)((Object)this.obj);
        }
        if (this.tileEntity instanceof IActionHost) {
            return (IActionHost)this.tileEntity;
        }
        if (this.part instanceof IActionHost) {
            return (IActionHost)((Object)this.part);
        }
        return null;
    }

    private void prepareSync() {
        for (Field f : ((Object)((Object)this)).getClass().getFields()) {
            if (!f.isAnnotationPresent(GuiSync.class)) continue;
            GuiSync annotation = f.getAnnotation(GuiSync.class);
            if (this.syncData.containsKey(annotation.value())) {
                AELog.warn("Channel already in use: " + annotation.value() + " for " + f.getName(), new Object[0]);
                continue;
            }
            this.syncData.put(annotation.value(), new SyncData(this, f, annotation));
        }
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetItem == null) {
                return;
            }
            if (stack != null && stack.isSameType(this.clientRequestedTargetItem)) {
                return;
            }
            NetworkHandler.instance().sendToServer(new TargetItemStackPacket((AEItemStack)stack));
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    public IActionSource getActionSource() {
        return this.mySrc;
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (Platform.isClient()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IGrid g;
        IGridNode gn;
        IActionHost host = this.getActionHost();
        if (host != null && (gn = host.getActionableNode()) != null && (g = gn.getGrid()) != null) {
            IEnergyGrid eg;
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (sg.hasPermission(this.getPlayerInventory().field_7546, perm)) {
                return true;
            }
        }
        return false;
    }

    public void lockPlayerInventorySlot(int idx) {
        this.locked.add(idx);
    }

    public Object getTarget() {
        if (this.tileEntity != null) {
            return this.tileEntity;
        }
        if (this.part != null) {
            return this.part;
        }
        if (this.obj != null) {
            return this.obj;
        }
        return null;
    }

    public class_1661 getPlayerInv() {
        return this.getPlayerInventory();
    }

    public class_2586 getBlockEntity() {
        return this.tileEntity;
    }

    public final void updateFullProgressBar(int idx, long value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
            return;
        }
        this.method_7606(idx, (int)value);
    }

    public void stringSync(int idx, String value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    protected void bindPlayerInventory(final class_1661 playerInventory, int offsetX, int offsetY) {
        int i;
        FixedInventoryVanillaWrapper ih = new FixedInventoryVanillaWrapper((class_1263)playerInventory){

            public class_1799 getInvStack(int slot) {
                return playerInventory.method_5438(slot);
            }
        };
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int invSlot = j + i * 9 + 9;
                int x = 8 + j * 18 + offsetX;
                int y = offsetY + i * 18;
                if (this.locked.contains(invSlot)) {
                    this.method_7621(new DisabledSlot((FixedItemInv)ih, invSlot, x, y));
                    continue;
                }
                this.method_7621(new PlayerInvSlot((FixedItemInv)ih, invSlot, x, y));
            }
        }
        for (i = 0; i < 9; ++i) {
            int x = 8 + i * 18 + offsetX;
            int y = 58 + offsetY;
            if (this.locked.contains(i)) {
                this.method_7621(new DisabledSlot((FixedItemInv)ih, i, x, y));
                continue;
            }
            this.method_7621(new PlayerHotBarSlot((FixedItemInv)ih, i, x, y));
        }
    }

    protected class_1735 method_7621(class_1735 newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setContainer(this);
            return super.method_7621(newSlot);
        }
        throw new IllegalArgumentException("Invalid Slot [" + newSlot + "] for AE Container instead of AppEngSlot.");
    }

    public List<class_1712> getListeners() {
        return ((ScreenHandlerListeners)((Object)this)).ae2_getListeners();
    }

    public void method_7623() {
        if (this.isServer()) {
            if (this.tileEntity != null && this.tileEntity.method_10997().method_8321(this.tileEntity.method_11016()) != this.tileEntity) {
                this.setValidContainer(false);
            }
            for (class_1712 listener : this.getListeners()) {
                for (SyncData sd : this.syncData.values()) {
                    sd.tick(listener);
                }
            }
        }
        super.method_7623();
    }

    public class_1799 method_7601(class_1657 p, int idx) {
        if (Platform.isClient()) {
            return class_1799.field_8037;
        }
        AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_7761.get(idx));
        if (clickSlot instanceof DisabledSlot || clickSlot instanceof InaccessibleSlot) {
            return class_1799.field_8037;
        }
        if (clickSlot != null && clickSlot.method_7681()) {
            AppEngSlot cs;
            class_1799 tis = clickSlot.method_7677();
            if (tis.method_7960()) {
                return class_1799.field_8037;
            }
            ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
            if (clickSlot.isPlayerSide()) {
                if (!(tis = this.transferStackToContainer(tis)).method_7960()) {
                    for (Object e : this.field_7761) {
                        cs = (AppEngSlot)((Object)e);
                        if (cs.isPlayerSide() || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.method_7680(tis)) continue;
                        selectedSlots.add(cs);
                    }
                }
            } else {
                tis = tis.method_7972();
                for (Object e : this.field_7761) {
                    cs = (AppEngSlot)((Object)e);
                    if (!cs.isPlayerSide() || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.method_7680(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && !tis.method_7960()) {
                for (Object e : this.field_7761) {
                    cs = (AppEngSlot)((Object)e);
                    class_1799 destination = cs.method_7677();
                    if (cs.isPlayerSide() || !(cs instanceof FakeSlot)) continue;
                    if (Platform.itemComparisons().isSameItem(destination, tis)) break;
                    if (!destination.method_7960()) continue;
                    cs.method_7673(tis.method_7972());
                    this.updateSlot(cs);
                    break;
                }
            }
            if (!tis.method_7960()) {
                int placeable;
                for (class_1735 class_17352 : selectedSlots) {
                    if (class_17352 instanceof DisabledSlot || class_17352 instanceof SlotME || !class_17352.method_7680(tis) || !class_17352.method_7681()) continue;
                    class_1799 t = class_17352.method_7677().method_7972();
                    if (!Platform.itemComparisons().isSameItem(t, tis)) continue;
                    int maxSize = t.method_7914();
                    if (maxSize > class_17352.method_7675()) {
                        maxSize = class_17352.method_7675();
                    }
                    if ((placeable = maxSize - t.method_7947()) <= 0) continue;
                    if (tis.method_7947() < placeable) {
                        placeable = tis.method_7947();
                    }
                    t.method_7939(t.method_7947() + placeable);
                    tis.method_7939(tis.method_7947() - placeable);
                    class_17352.method_7673(t);
                    if (tis.method_7947() <= 0) {
                        clickSlot.method_7673(class_1799.field_8037);
                        class_17352.method_7668();
                        this.updateSlot(clickSlot);
                        this.updateSlot(class_17352);
                        return class_1799.field_8037;
                    }
                    this.updateSlot(class_17352);
                }
                for (class_1735 class_17353 : selectedSlots) {
                    class_1799 tmp;
                    if (class_17353 instanceof DisabledSlot || class_17353 instanceof SlotME || !class_17353.method_7680(tis)) continue;
                    if (class_17353.method_7681()) {
                        class_1799 t = class_17353.method_7677().method_7972();
                        if (!Platform.itemComparisons().isSameItem(t, tis)) continue;
                        int maxSize = t.method_7914();
                        if (maxSize > class_17353.method_7675()) {
                            maxSize = class_17353.method_7675();
                        }
                        if ((placeable = maxSize - t.method_7947()) <= 0) continue;
                        if (tis.method_7947() < placeable) {
                            placeable = tis.method_7947();
                        }
                        t.method_7939(t.method_7947() + placeable);
                        tis.method_7939(tis.method_7947() - placeable);
                        class_17353.method_7673(t);
                        if (tis.method_7947() <= 0) {
                            clickSlot.method_7673(class_1799.field_8037);
                            class_17353.method_7668();
                            this.updateSlot(clickSlot);
                            this.updateSlot(class_17353);
                            return class_1799.field_8037;
                        }
                        this.updateSlot(class_17353);
                        continue;
                    }
                    int maxSize = tis.method_7914();
                    if (maxSize > class_17353.method_7675()) {
                        maxSize = class_17353.method_7675();
                    }
                    if ((tmp = tis.method_7972()).method_7947() > maxSize) {
                        tmp.method_7939(maxSize);
                    }
                    tis.method_7939(tis.method_7947() - tmp.method_7947());
                    class_17353.method_7673(tmp);
                    if (tis.method_7947() <= 0) {
                        clickSlot.method_7673(class_1799.field_8037);
                        class_17353.method_7668();
                        this.updateSlot(clickSlot);
                        this.updateSlot(class_17353);
                        return class_1799.field_8037;
                    }
                    this.updateSlot(class_17353);
                }
            }
            clickSlot.method_7673(!tis.method_7960() ? tis : class_1799.field_8037);
        }
        this.updateSlot(clickSlot);
        return class_1799.field_8037;
    }

    public final void method_7606(int idx, int value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    public boolean method_7597(class_1657 player) {
        if (this.isValidContainer()) {
            if (this.tileEntity instanceof class_1263) {
                return ((class_1263)this.tileEntity).method_5443(player);
            }
            return true;
        }
        return false;
    }

    public boolean method_7615(class_1735 slot) {
        return ((AppEngSlot)slot).isDraggable();
    }

    public void doAction(class_3222 player, InventoryAction action, int slot, long id) {
        if (slot >= 0 && slot < this.field_7761.size()) {
            class_1735 s = this.method_7611(slot);
            if (s instanceof CraftingTermSlot) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((CraftingTermSlot)s).doClick(action, (class_1657)player);
                        this.updateHeld(player);
                    }
                }
            }
            if (s instanceof FakeSlot) {
                class_1799 hand = player.field_7514.method_7399();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (hand.method_7960()) {
                            s.method_7673(class_1799.field_8037);
                            break;
                        }
                        s.method_7673(hand.method_7972());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (hand.method_7960()) break;
                        class_1799 is = hand.method_7972();
                        is.method_7939(1);
                        s.method_7673(is);
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        class_1799 is = s.method_7677();
                        if (!is.method_7960()) {
                            if (hand.method_7960()) {
                                is.method_7939(Math.max(1, is.method_7947() - 1));
                            } else if (hand.method_7929(is)) {
                                is.method_7939(Math.min(is.method_7914(), is.method_7947() + 1));
                            } else {
                                is = hand.method_7972();
                                is.method_7939(1);
                            }
                            s.method_7673(is);
                            break;
                        }
                        if (hand.method_7960()) break;
                        is = hand.method_7972();
                        is.method_7939(1);
                        s.method_7673(is);
                        break;
                    }
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                ArrayList<Integer> from = new ArrayList<Integer>();
                for (int i = 0; i < this.field_7761.size(); ++i) {
                    class_1735 j = (class_1735)this.field_7761.get(i);
                    if (j.getClass() != s.getClass() || j instanceof CraftingTermSlot) continue;
                    from.add(i);
                }
                Iterator i = from.iterator();
                while (i.hasNext()) {
                    int fromIndex = (Integer)i.next();
                    this.method_7601((class_1657)player, fromIndex);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.clientRequestedTargetItem;
        switch (action) {
            case SHIFT_CLICK: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                IAEItemStack ais = slotItem.copy();
                class_1799 myItem = ais.createItemStack();
                ais.setStackSize(myItem.method_7914());
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor((class_1657)player);
                myItem.method_7939((int)ais.getStackSize());
                myItem = adp.simulateAdd(myItem);
                if (!myItem.method_7960()) {
                    ais.setStackSize(ais.getStackSize() - (long)myItem.method_7947());
                }
                if ((ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource())) == null) break;
                adp.addItems(ais.createItemStack());
                break;
            }
            case ROLL_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                boolean releaseQty = true;
                class_1799 isg = player.field_7514.method_7399();
                if (isg.method_7960()) break;
                IAEItemStack ais = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(isg);
                ais.setStackSize(1L);
                IAEItemStack extracted = ais.copy();
                ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais != null) break;
                AdaptorFixedInv ia = new AdaptorFixedInv((FixedItemInv)new WrapperCursorItemHandler(player.field_7514));
                class_1799 fail = ((InventoryAdaptor)ia).removeItems(1, extracted.getDefinition(), null);
                if (fail.method_7960()) {
                    this.getCellInventory().extractItems(extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int liftQty = 1;
                class_1799 item = player.field_7514.method_7399();
                if (!item.method_7960()) {
                    if (item.method_7947() >= item.method_7914()) {
                        liftQty = 0;
                    }
                    if (!Platform.itemComparisons().isSameItem(slotItem.getDefinition(), item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais = slotItem.copy();
                ais.setStackSize(1L);
                ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais == null) break;
                AdaptorFixedInv ia = new AdaptorFixedInv((FixedItemInv)new WrapperCursorItemHandler(player.field_7514));
                class_1799 fail = ((InventoryAdaptor)ia).addItems(ais.createItemStack());
                if (!fail.method_7960()) {
                    this.getCellInventory().injectItems(ais, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_7514.method_7399().method_7960()) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    ais.setStackSize(ais.getDefinition().method_7914());
                    ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                    if (ais != null) {
                        player.field_7514.method_7396(ais.createItemStack());
                    } else {
                        player.field_7514.method_7396(class_1799.field_8037);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(player.field_7514.method_7399());
                ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais != null) {
                    player.field_7514.method_7396(ais.createItemStack());
                } else {
                    player.field_7514.method_7396(class_1799.field_8037);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_7514.method_7399().method_7960()) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    long maxSize = ais.getDefinition().method_7914();
                    ais.setStackSize(maxSize);
                    ais = this.getCellInventory().extractItems(ais, Actionable.SIMULATE, this.getActionSource());
                    if (ais != null) {
                        long stackSize = Math.min(maxSize, ais.getStackSize());
                        ais.setStackSize(stackSize + 1L >> 1);
                        ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                    }
                    if (ais != null) {
                        player.field_7514.method_7396(ais.createItemStack());
                    } else {
                        player.field_7514.method_7396(class_1799.field_8037);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(player.field_7514.method_7399());
                ais.setStackSize(1L);
                ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource());
                if (ais != null) break;
                class_1799 is = player.field_7514.method_7399();
                is.method_7939(is.method_7947() - 1);
                if (is.method_7947() <= 0) {
                    player.field_7514.method_7396(class_1799.field_8037);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.method_7337() || slotItem == null) break;
                class_1799 is = slotItem.createItemStack();
                is.method_7939(is.method_7914());
                player.field_7514.method_7396(is);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int playerInv = 36;
                for (int slotNum = 0; slotNum < 36; ++slotNum) {
                    IAEItemStack ais = slotItem.copy();
                    class_1799 myItem = ais.createItemStack();
                    ais.setStackSize(myItem.method_7914());
                    InventoryAdaptor adp = InventoryAdaptor.getAdaptor((class_1657)player);
                    myItem.method_7939((int)ais.getStackSize());
                    myItem = adp.simulateAdd(myItem);
                    if (!myItem.method_7960()) {
                        ais.setStackSize(ais.getStackSize() - (long)myItem.method_7947());
                    }
                    if ((ais = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), ais, this.getActionSource())) == null) {
                        return;
                    }
                    adp.addItems(ais.createItemStack());
                }
                break;
            }
        }
    }

    protected void updateHeld(class_3222 p) {
        if (Platform.isServer()) {
            NetworkHandler.instance().sendTo(new InventoryActionPacket(InventoryAction.UPDATE_HAND, 0, AEItemStack.fromItemStack(p.field_7514.method_7399())), p);
        }
    }

    protected class_1799 transferStackToContainer(class_1799 input) {
        return this.shiftStoreItem(input);
    }

    private class_1799 shiftStoreItem(class_1799 input) {
        if (this.getPowerSource() == null || this.getCellInventory() == null) {
            return input;
        }
        IAEItemStack ais = Platform.poweredInsert(this.getPowerSource(), this.getCellInventory(), Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(input), this.getActionSource());
        if (ais == null) {
            return class_1799.field_8037;
        }
        return ais.createItemStack();
    }

    private void updateSlot(class_1735 clickSlot) {
        this.method_7623();
    }

    public void swapSlotContents(int slotA, int slotB) {
        class_1799 testB;
        class_1735 a = this.method_7611(slotA);
        class_1735 b = this.method_7611(slotB);
        if (a == null || b == null) {
            return;
        }
        class_1799 isA = a.method_7677();
        class_1799 isB = b.method_7677();
        if (isA.method_7960() && isB.method_7960()) {
            return;
        }
        if (!isA.method_7960() && !a.method_7674(this.getPlayerInventory().field_7546)) {
            return;
        }
        if (!isB.method_7960() && !b.method_7674(this.getPlayerInventory().field_7546)) {
            return;
        }
        if (!isB.method_7960() && !a.method_7680(isB)) {
            return;
        }
        if (!isA.method_7960() && !b.method_7680(isA)) {
            return;
        }
        class_1799 testA = isB.method_7960() ? class_1799.field_8037 : isB.method_7972();
        class_1799 class_17992 = testB = isA.method_7960() ? class_1799.field_8037 : isA.method_7972();
        if (!testA.method_7960() && testA.method_7947() > a.method_7675()) {
            if (!testB.method_7960()) {
                return;
            }
            int totalA = testA.method_7947();
            testA.method_7939(a.method_7675());
            testB = testA.method_7972();
            testB.method_7939(totalA - testA.method_7947());
        }
        if (!testB.method_7960() && testB.method_7947() > b.method_7675()) {
            if (!testA.method_7960()) {
                return;
            }
            int totalB = testB.method_7947();
            testB.method_7939(b.method_7675());
            testA = testB.method_7972();
            testA.method_7939(totalB - testA.method_7947());
        }
        a.method_7673(testA);
        b.method_7673(testB);
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
    }

    public void onSlotChange(class_1735 s) {
    }

    public boolean isValidForSlot(class_1735 s, class_1799 i) {
        return true;
    }

    public IMEInventoryHandler<IAEItemStack> getCellInventory() {
        return this.cellInv;
    }

    public void setCellInventory(IMEInventoryHandler<IAEItemStack> cellInv) {
        this.cellInv = cellInv;
    }

    public class_1661 getPlayerInventory() {
        return this.invPlayer;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public ContainerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ContainerLocator locator) {
        this.locator = locator;
    }

    public IEnergySource getPowerSource() {
        return this.powerSrc;
    }

    public void setPowerSource(IEnergySource powerSrc) {
        this.powerSrc = powerSrc;
    }

    protected boolean isClient() {
        return this.invPlayer.field_7546.method_5770().method_8608();
    }

    protected boolean isServer() {
        return !this.isClient();
    }
}

