/*
 * Decompiled with CFR 0.152.
 */
package appeng.container;

import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.parts.AEBasePart;
import com.google.common.base.Preconditions;
import io.netty.handler.codec.DecoderException;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public final class ContainerLocator {
    private final Type type;
    private final int itemIndex;
    private final class_2960 worldId;
    private final class_2338 blockPos;
    private final AEPartLocation side;

    private ContainerLocator(Type type, int itemIndex, class_1937 world, class_2338 blockPos, AEPartLocation side) {
        this(type, itemIndex, world.method_27983().method_29177(), blockPos, side);
    }

    private ContainerLocator(Type type, int itemIndex, class_2960 worldId, class_2338 blockPos, AEPartLocation side) {
        this.type = type;
        this.itemIndex = itemIndex;
        this.worldId = worldId;
        this.blockPos = blockPos;
        this.side = side;
    }

    public static ContainerLocator forTileEntity(class_2586 te) {
        if (te.method_10997() == null) {
            throw new IllegalArgumentException("Cannot open a block entity that is not in a world");
        }
        return new ContainerLocator(Type.BLOCK, -1, te.method_10997(), te.method_11016(), null);
    }

    public static ContainerLocator forTileEntitySide(class_2586 te, class_2350 side) {
        if (te.method_10997() == null) {
            throw new IllegalArgumentException("Cannot open a block entity that is not in a world");
        }
        return new ContainerLocator(Type.PART, -1, te.method_10997(), te.method_11016(), AEPartLocation.fromFacing(side));
    }

    public static ContainerLocator forItemUseContext(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            throw new IllegalArgumentException("Cannot open a container without a player");
        }
        int slot = ContainerLocator.getPlayerInventorySlotFromHand(player, context.method_20287());
        AEPartLocation side = AEPartLocation.fromFacing(context.method_8038());
        return new ContainerLocator(Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT, slot, player.field_6002, context.method_8037(), side);
    }

    public static ContainerLocator forHand(class_1657 player, class_1268 hand) {
        int slot = ContainerLocator.getPlayerInventorySlotFromHand(player, hand);
        return new ContainerLocator(Type.PLAYER_INVENTORY, slot, (class_2960)null, null, null);
    }

    private static int getPlayerInventorySlotFromHand(class_1657 player, class_1268 hand) {
        class_1799 is = player.method_5998(hand);
        if (is.method_7960()) {
            throw new IllegalArgumentException("Cannot open an item-inventory with empty hands");
        }
        int invSize = player.field_7514.method_5439();
        for (int i = 0; i < invSize; ++i) {
            if (player.field_7514.method_5438(i) != is) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find item held in hand " + hand + " in player inventory");
    }

    public static ContainerLocator forPart(AEBasePart part) {
        IPartHost host = part.getHost();
        DimensionalCoord pos = host.getLocation();
        return new ContainerLocator(Type.PART, -1, pos.getWorld(), pos.getBlockPos(), part.getSide());
    }

    public boolean hasItemIndex() {
        return this.type == Type.PLAYER_INVENTORY || this.type == Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT;
    }

    public int getItemIndex() {
        Preconditions.checkState((boolean)this.hasItemIndex());
        return this.itemIndex;
    }

    public class_2960 getWorldId() {
        return this.worldId;
    }

    public boolean hasBlockPos() {
        return this.type == Type.BLOCK || this.type == Type.PART || this.type == Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT;
    }

    public class_2338 getBlockPos() {
        Preconditions.checkState((boolean)this.hasBlockPos());
        return this.blockPos;
    }

    public boolean hasSide() {
        return this.type == Type.PART || this.type == Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT;
    }

    public AEPartLocation getSide() {
        Preconditions.checkState((boolean)this.hasSide());
        return this.side;
    }

    public void write(class_2540 buf) {
        switch (this.type) {
            case PLAYER_INVENTORY: {
                buf.writeByte(0);
                buf.writeInt(this.itemIndex);
                break;
            }
            case PLAYER_INVENTORY_WITH_BLOCK_CONTEXT: {
                buf.writeByte(1);
                buf.writeInt(this.itemIndex);
                buf.method_10812(this.worldId);
                buf.method_10807(this.blockPos);
                buf.writeByte(this.side.ordinal());
                break;
            }
            case BLOCK: {
                buf.writeByte(2);
                buf.method_10812(this.worldId);
                buf.method_10807(this.blockPos);
                break;
            }
            case PART: {
                buf.writeByte(3);
                buf.method_10812(this.worldId);
                buf.method_10807(this.blockPos);
                buf.writeByte(this.side.ordinal());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported ContainerLocator type: " + (Object)((Object)this.type));
            }
        }
    }

    public static ContainerLocator read(class_2540 buf) {
        byte type = buf.readByte();
        switch (type) {
            case 0: {
                return new ContainerLocator(Type.PLAYER_INVENTORY, buf.readInt(), (class_2960)null, null, null);
            }
            case 1: {
                return new ContainerLocator(Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT, buf.readInt(), buf.method_10810(), buf.method_10811(), AEPartLocation.values()[buf.readByte()]);
            }
            case 2: {
                return new ContainerLocator(Type.BLOCK, -1, buf.method_10810(), buf.method_10811(), null);
            }
            case 3: {
                return new ContainerLocator(Type.PART, -1, buf.method_10810(), buf.method_10811(), AEPartLocation.values()[buf.readByte()]);
            }
        }
        throw new DecoderException("ContainerLocator type out of range: " + type);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.type.name());
        result.append('{');
        if (this.hasItemIndex()) {
            result.append("slot=").append(this.itemIndex).append(',');
        }
        if (this.hasBlockPos()) {
            result.append("dim=").append(this.worldId).append(',');
            result.append("pos=").append(this.blockPos).append(',');
        }
        if (this.hasSide()) {
            result.append("side=").append((Object)this.side).append(',');
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.setLength(result.length() - 1);
        }
        result.append('}');
        return result.toString();
    }

    private static enum Type {
        PLAYER_INVENTORY,
        PLAYER_INVENTORY_WITH_BLOCK_CONTEXT,
        BLOCK,
        PART;

    }
}

