/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.guisync;

import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.ProgressBarPacket;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class SyncData {
    private final AEBaseContainer source;
    private final Field field;
    private final Class<?> fieldType;
    private final int channel;
    private final MethodHandle getter;
    private final MethodHandle setter;
    private Object clientVersion = null;

    public SyncData(AEBaseContainer container, Field field, GuiSync annotation) {
        this.source = container;
        this.channel = annotation.value();
        this.field = field;
        this.fieldType = field.getType();
        try {
            this.getter = MethodHandles.publicLookup().unreflectGetter(field);
            this.setter = MethodHandles.publicLookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get accessor for field " + field + ". Did you forget to make it public?");
        }
    }

    public int getChannel() {
        return this.channel;
    }

    public void tick(class_1712 c) {
        try {
            Object val = this.getter.invoke(this.source);
            if (!Objects.equals(val, this.clientVersion)) {
                this.send(c, val);
            }
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void send(class_1712 o, Object val) {
        if (this.fieldType.isAssignableFrom(class_2561.class)) {
            if (o instanceof class_3222) {
                String json = "";
                if (val != null) {
                    json = class_2561.class_2562.method_10867((class_2561)((class_2561)val));
                }
                NetworkHandler.instance().sendTo(new ConfigValuePacket("SyncDat." + this.channel, json), (class_3222)o);
            }
            this.clientVersion = val;
            return;
        }
        if (val == null) {
            return;
        }
        if (this.fieldType.equals(String.class)) {
            if (o instanceof class_3222) {
                NetworkHandler.instance().sendTo(new ConfigValuePacket("SyncDat." + this.channel, (String)val), (class_3222)o);
            }
        } else if (this.fieldType.isEnum()) {
            o.method_7633((class_1703)this.source, this.channel, ((Enum)val).ordinal());
        } else if (val instanceof Long) {
            if (o instanceof class_3222) {
                NetworkHandler.instance().sendTo(new ProgressBarPacket(this.channel, (Long)val), (class_3222)o);
            }
        } else if (this.fieldType.equals(Boolean.class) || this.fieldType.equals(Boolean.TYPE)) {
            o.method_7633((class_1703)this.source, this.channel, (Boolean)val != false ? 1 : 0);
        } else if (this.fieldType.equals(Integer.class) || this.fieldType.equals(Integer.TYPE)) {
            o.method_7633((class_1703)this.source, this.channel, ((Integer)val).intValue());
        } else {
            throw new IllegalStateException("Unknown field type: " + this.fieldType);
        }
        this.clientVersion = val;
    }

    public void update(Object val) {
        try {
            Object oldValue = this.getter.invoke(this.source);
            if (val instanceof String) {
                if (this.fieldType.isAssignableFrom(class_2561.class)) {
                    String json = (String)val;
                    class_5250 text = null;
                    if (!json.isEmpty()) {
                        text = class_2561.class_2562.method_10877((String)((String)val));
                    }
                    this.updateTextComponent((class_2561)text);
                } else {
                    this.updateString((String)val);
                }
            } else {
                this.updateValue(oldValue, (Long)val);
            }
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void updateString(String val) {
        try {
            this.setter.invoke(this.source, val);
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void updateTextComponent(class_2561 val) {
        try {
            this.setter.invoke(this.source, val);
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }

    private void updateValue(Object oldValue, long val) {
        try {
            if (this.fieldType.isEnum()) {
                Object e = this.fieldType.getEnumConstants()[(int)val];
                this.setter.invoke(this.source, e);
            } else if (this.fieldType.equals(Integer.TYPE)) {
                this.setter.invoke(this.source, (int)val);
            } else if (this.fieldType.equals(Long.TYPE)) {
                this.setter.invoke(this.source, val);
            } else if (this.fieldType.equals(Boolean.TYPE)) {
                this.setter.invoke(this.source, val == 1L);
            } else if (this.fieldType.equals(Integer.class)) {
                this.setter.invoke(this.source, (int)val);
            } else if (this.fieldType.equals(Long.class)) {
                this.setter.invoke(this.source, val);
            } else if (this.fieldType.equals(Boolean.class)) {
                this.setter.invoke(this.source, val == 1L);
            }
            this.source.onUpdate(this.field.getName(), oldValue, this.getter.invoke(this.source));
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
    }
}

