/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.FakeTypeOnlySlot;
import appeng.container.slot.OptionalRestrictedInputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.tile.misc.CellWorkbenchBlockEntity;
import appeng.util.EnumCycler;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperSupplierItemHandler;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class CellWorkbenchContainer
extends UpgradeableContainer {
    public static class_3917<CellWorkbenchContainer> TYPE;
    private static final ContainerHelper<CellWorkbenchContainer, CellWorkbenchBlockEntity> helper;
    private final CellWorkbenchBlockEntity workBench;
    @GuiSync(value=2)
    public CopyMode copyMode = CopyMode.CLEAR_ON_REMOVE;
    private class_1799 prevStack = class_1799.field_8037;
    private int lastUpgrades = 0;

    public CellWorkbenchContainer(int id, class_1661 ip, CellWorkbenchBlockEntity te) {
        super(TYPE, id, ip, te);
        this.workBench = te;
    }

    public static CellWorkbenchContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public void setFuzzy(FuzzyMode valueOf) {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            cwi.setFuzzyMode(this.workBench.getInventoryByName("cell").getInvStack(0), valueOf);
        }
    }

    public void nextWorkBenchCopyMode() {
        this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, EnumCycler.next(this.getWorkBenchCopyMode()));
    }

    private CopyMode getWorkBenchCopyMode() {
        return (CopyMode)this.workBench.getConfigManager().getSetting(Settings.COPY_MODE);
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    protected void setupConfig() {
        int z;
        FixedItemInv cell = this.getUpgradeable().getInventoryByName("cell");
        this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.WORKBENCH_CELL, cell, 0, 152, 8, this.getPlayerInv()));
        FixedItemInv inv = this.getUpgradeable().getInventoryByName("config");
        WrapperSupplierItemHandler upgradeInventory = new WrapperSupplierItemHandler(this::getCellUpgradeInventory);
        int offset = 0;
        int y = 29;
        int x = 8;
        for (int w = 0; w < 7; ++w) {
            for (z = 0; z < 9; ++z) {
                this.method_7621(new FakeTypeOnlySlot(inv, offset, 8 + z * 18, 29 + w * 18));
                ++offset;
            }
        }
        for (int zz = 0; zz < 3; ++zz) {
            for (z = 0; z < 8; ++z) {
                int iSLot = zz * 8 + z;
                this.method_7621(new OptionalRestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgradeInventory, this, iSLot, 187 + zz * 18, 8 + 18 * z, iSLot, this.getPlayerInventory()));
            }
        }
    }

    @Override
    public int availableUpgrades() {
        class_1799 is = this.workBench.getInventoryByName("cell").getInvStack(0);
        if (this.prevStack != is) {
            this.prevStack = is;
            this.lastUpgrades = this.getCellUpgradeInventory().getSlotCount();
        }
        return this.lastUpgrades;
    }

    @Override
    public void method_7623() {
        class_1799 is = this.workBench.getInventoryByName("cell").getInvStack(0);
        if (this.isServer()) {
            for (class_1712 listener : this.getListeners()) {
                if (this.prevStack == is) continue;
                for (int i = 0; i < this.field_7761.size(); ++i) {
                    class_1735 s = (class_1735)this.field_7761.get(i);
                    if (!(s instanceof OptionalRestrictedInputSlot)) continue;
                    OptionalRestrictedInputSlot sri = (OptionalRestrictedInputSlot)s;
                    listener.method_7635((class_1703)this, i, sri.method_7677());
                }
                if (!(listener instanceof class_3222)) continue;
                ((class_3222)listener).field_13991 = false;
            }
            this.setCopyMode(this.getWorkBenchCopyMode());
            this.setFuzzyMode(this.getWorkBenchFuzzyMode());
        }
        this.prevStack = is;
        this.standardDetectAndSendChanges();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return idx < this.availableUpgrades();
    }

    public FixedItemInv getCellUpgradeInventory() {
        FixedItemInv upgradeInventory = this.workBench.getCellUpgradeInventory();
        return upgradeInventory == null ? EmptyFixedItemInv.INSTANCE : upgradeInventory;
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("copyMode")) {
            this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, this.getCopyMode());
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void clear() {
        ItemHandlerUtil.clear(this.getUpgradeable().getInventoryByName("config"));
        this.method_7623();
    }

    private FuzzyMode getWorkBenchFuzzyMode() {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            return cwi.getFuzzyMode(this.workBench.getInventoryByName("cell").getInvStack(0));
        }
        return FuzzyMode.IGNORE_ALL;
    }

    public void partition() {
        FixedItemInv inv = this.getUpgradeable().getInventoryByName("config");
        class_1799 is = this.getUpgradeable().getInventoryByName("cell").getInvStack(0);
        IItemStorageChannel channel = is.method_7909() instanceof IStorageCell ? ((IStorageCell)is.method_7909()).getChannel() : Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
        ICellInventoryHandler<IAEItemStack> cellInv = Api.instance().registries().cell().getCellInventory(is, null, channel);
        Iterator i = new NullIterator();
        if (cellInv != null) {
            IItemList list = cellInv.getAvailableItems(channel.createList());
            i = list.iterator();
        }
        for (int x = 0; x < inv.getSlotCount(); ++x) {
            if (i.hasNext()) {
                class_1799 g = ((IAEStack)i.next()).asItemStackRepresentation();
                ItemHandlerUtil.setStackInSlot(inv, x, g);
                continue;
            }
            ItemHandlerUtil.setStackInSlot(inv, x, class_1799.field_8037);
        }
        this.method_7623();
    }

    public CopyMode getCopyMode() {
        return this.copyMode;
    }

    private void setCopyMode(CopyMode copyMode) {
        this.copyMode = copyMode;
    }

    static {
        helper = new ContainerHelper<CellWorkbenchContainer, CellWorkbenchBlockEntity>(CellWorkbenchContainer::new, CellWorkbenchBlockEntity.class);
    }
}

