/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.misc.CondenserBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class CondenserContainer
extends AEBaseContainer
implements IProgressProvider {
    public static class_3917<CondenserContainer> TYPE;
    private static final ContainerHelper<CondenserContainer, CondenserBlockEntity> helper;
    private final CondenserBlockEntity condenser;
    @GuiSync(value=0)
    public long requiredEnergy = 0L;
    @GuiSync(value=1)
    public long storedPower = 0L;
    @GuiSync(value=2)
    public CondenserOutput output = CondenserOutput.TRASH;

    public CondenserContainer(int id, class_1661 ip, CondenserBlockEntity condenser) {
        super(TYPE, id, ip, condenser, null);
        this.condenser = condenser;
        FixedItemInv inv = condenser.getInternalInventory();
        this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.TRASH, inv, 0, 51, 52, ip));
        this.method_7621(new OutputSlot(inv, 1, 105, 52, -1));
        this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.STORAGE_COMPONENT, inv, 2, 101, 26, ip).setStackLimit(1));
        this.bindPlayerInventory(ip, 0, 115);
    }

    public static CondenserContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    @Override
    public void method_7623() {
        if (this.isServer()) {
            double maxStorage = this.condenser.getStorage();
            double requiredEnergy = this.condenser.getRequiredPower();
            this.requiredEnergy = requiredEnergy == 0.0 ? (long)((int)maxStorage) : (long)((int)Math.min(requiredEnergy, maxStorage));
            this.storedPower = (int)this.condenser.getStoredPower();
            this.output = (CondenserOutput)this.condenser.getConfigManager().getSetting(Settings.CONDENSER_OUTPUT);
        }
        super.method_7623();
    }

    @Override
    public int getCurrentProgress() {
        return (int)this.storedPower;
    }

    @Override
    public int getMaxProgress() {
        return (int)this.requiredEnergy;
    }

    public CondenserOutput getOutput() {
        return this.output;
    }

    static {
        helper = new ContainerHelper<CondenserContainer, CondenserBlockEntity>(CondenserContainer::new, CondenserBlockEntity.class);
    }
}

