/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.Platform;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public final class ContainerHelper<C extends AEBaseContainer, I> {
    private final Class<I> interfaceClass;
    private final ContainerFactory<C, I> factory;
    private final SecurityPermissions requiredPermission;
    private Function<I, class_2561> containerTitleStrategy = this::getDefaultContainerTitle;

    public ContainerHelper(ContainerFactory<C, I> factory, Class<I> interfaceClass) {
        this(factory, interfaceClass, null);
    }

    public ContainerHelper(ContainerFactory<C, I> factory, Class<I> interfaceClass, SecurityPermissions requiredPermission) {
        this.requiredPermission = requiredPermission;
        this.interfaceClass = interfaceClass;
        this.factory = factory;
    }

    public ContainerHelper<C, I> withContainerTitle(Function<I, class_2561> containerTitleStrategy) {
        this.containerTitleStrategy = containerTitleStrategy;
        return this;
    }

    public C fromNetwork(int windowId, class_1661 inv, class_2540 packetBuf) {
        return (C)((Object)this.fromNetwork(windowId, inv, packetBuf, (accessObj, container, buffer) -> {}));
    }

    public C fromNetwork(int windowId, class_1661 inv, class_2540 packetBuf, InitialDataDeserializer<C, I> initialDataDeserializer) {
        I host = this.getHostFromLocator(inv.field_7546, ContainerLocator.read(packetBuf));
        if (host != null) {
            AEBaseContainer container = (AEBaseContainer)((Object)this.factory.create(windowId, inv, host));
            initialDataDeserializer.deserializeInitialData(host, container, packetBuf);
            return (C)((Object)container);
        }
        return null;
    }

    public boolean open(class_1657 player, ContainerLocator locator) {
        return this.open(player, locator, (accessObj, buffer) -> {});
    }

    public boolean open(class_1657 player, ContainerLocator locator, InitialDataSerializer<I> initialDataSerializer) {
        if (!(player instanceof class_3222)) {
            return false;
        }
        I accessInterface = this.getHostFromLocator(player, locator);
        if (accessInterface == null) {
            return false;
        }
        if (!this.checkPermission(player, accessInterface)) {
            return false;
        }
        class_2561 title = this.containerTitleStrategy.apply(accessInterface);
        player.method_17355((class_3908)new HandlerFactory(locator, title, accessInterface, initialDataSerializer));
        return true;
    }

    private I getHostFromLocator(class_1657 player, ContainerLocator locator) {
        if (locator.hasItemIndex()) {
            return this.getHostFromPlayerInventory(player, locator);
        }
        if (!locator.hasBlockPos()) {
            return null;
        }
        class_2586 tileEntity = player.field_6002.method_8321(locator.getBlockPos());
        if (this.interfaceClass.isInstance(tileEntity)) {
            return this.interfaceClass.cast(tileEntity);
        }
        if (!locator.hasSide()) {
            return null;
        }
        if (tileEntity instanceof IPartHost) {
            IPartHost partHost = (IPartHost)tileEntity;
            IPart part = partHost.getPart(locator.getSide());
            if (part == null) {
                return null;
            }
            if (this.interfaceClass.isInstance(part)) {
                return this.interfaceClass.cast(part);
            }
            AELog.debug("Trying to open a container @ %s for a %s, but the container requires %s", locator, part.getClass(), this.interfaceClass);
            return null;
        }
        return null;
    }

    private I getHostFromPlayerInventory(class_1657 player, ContainerLocator locator) {
        IWirelessTermHandler wh;
        class_1799 it = player.field_7514.method_5438(locator.getItemIndex());
        if (it.method_7960()) {
            AELog.debug("Cannot open container for player %s since they no longer hold the item in slot %d", player, locator.hasItemIndex());
            return null;
        }
        if (it.method_7909() instanceof IGuiItem) {
            IGuiItem guiItem = (IGuiItem)it.method_7909();
            class_2338 blockPos = locator.hasBlockPos() ? locator.getBlockPos() : null;
            IGuiItemObject guiObject = guiItem.getGuiObject(it, locator.getItemIndex(), player.field_6002, blockPos);
            if (this.interfaceClass.isInstance(guiObject)) {
                return this.interfaceClass.cast(guiObject);
            }
        }
        if (this.interfaceClass.isAssignableFrom(WirelessTerminalGuiObject.class) && (wh = Api.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return this.interfaceClass.cast(new WirelessTerminalGuiObject(wh, it, player, locator.getItemIndex()));
        }
        return null;
    }

    private boolean checkPermission(class_1657 player, Object accessInterface) {
        if (this.requiredPermission != null) {
            return Platform.checkPermissions(player, accessInterface, this.requiredPermission, true);
        }
        return true;
    }

    private class_2561 getDefaultContainerTitle(I accessInterface) {
        ICustomNameObject customNameObject;
        if (accessInterface instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)accessInterface).hasCustomInventoryName()) {
            return customNameObject.getCustomInventoryName();
        }
        return class_2585.field_24366;
    }

    @FunctionalInterface
    public static interface InitialDataDeserializer<C, I> {
        public void deserializeInitialData(I var1, C var2, class_2540 var3);
    }

    @FunctionalInterface
    public static interface InitialDataSerializer<I> {
        public void serializeInitialData(I var1, class_2540 var2);
    }

    @FunctionalInterface
    public static interface ContainerFactory<C, I> {
        public C create(int var1, class_1661 var2, I var3);
    }

    private class HandlerFactory
    implements ExtendedScreenHandlerFactory {
        private final ContainerLocator locator;
        private final I accessInterface;
        private final class_2561 title;
        private final InitialDataSerializer<I> initialDataSerializer;

        public HandlerFactory(ContainerLocator locator, class_2561 title, I accessInterface, InitialDataSerializer<I> initialDataSerializer) {
            this.locator = locator;
            this.title = title;
            this.accessInterface = accessInterface;
            this.initialDataSerializer = initialDataSerializer;
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            this.locator.write(buf);
            this.initialDataSerializer.serializeInitialData(this.accessInterface, buf);
        }

        public class_2561 method_5476() {
            return this.title;
        }

        @Nullable
        public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
            AEBaseContainer c = (AEBaseContainer)((Object)ContainerHelper.this.factory.create(syncId, inv, this.accessInterface));
            c.setLocator(this.locator);
            return c;
        }
    }
}

