/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.CraftingCPUCycler;
import appeng.container.implementations.CraftingCPUCyclingContainer;
import appeng.container.implementations.CraftingCPURecord;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.me.helpers.PlayerSource;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.parts.reporting.TerminalPart;
import java.io.IOException;
import java.util.concurrent.Future;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1712;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class CraftConfirmContainer
extends AEBaseContainer
implements CraftingCPUCyclingContainer {
    public static class_3917<CraftConfirmContainer> TYPE;
    private static final ContainerHelper<CraftConfirmContainer, ITerminalHost> helper;
    private final CraftingCPUCycler cpuCycler = new CraftingCPUCycler(this::cpuMatches, this::onCPUSelectionChanged);
    private ICraftingCPU selectedCpu;
    private Future<ICraftingJob> job;
    private ICraftingJob result;
    @GuiSync(value=0)
    public long bytesUsed;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=4)
    public boolean simulation = true;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=7)
    public class_2561 cpuName;

    public static CraftConfirmContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public CraftConfirmContainer(int id, class_1661 ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
        this.cpuCycler.setAllowNoSelection(true);
    }

    @Override
    public void cycleSelectedCPU(boolean next) {
        this.cpuCycler.cycleCpu(next);
    }

    @Override
    public void method_7623() {
        if (this.isClient()) {
            return;
        }
        this.cpuCycler.detectAndSendChanges(this.getGrid());
        super.method_7623();
        if (this.getJob() != null && this.getJob().isDone()) {
            try {
                this.result = this.getJob().get();
                if (!this.result.isSimulation()) {
                    this.setSimulation(false);
                    if (this.isAutoStart()) {
                        this.startJob();
                        return;
                    }
                } else {
                    this.setSimulation(true);
                }
                try {
                    MEInventoryUpdatePacket a = new MEInventoryUpdatePacket(0);
                    MEInventoryUpdatePacket b = new MEInventoryUpdatePacket(1);
                    MEInventoryUpdatePacket c = this.result.isSimulation() ? new MEInventoryUpdatePacket(2) : null;
                    IItemList<IAEItemStack> plan = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                    this.result.populatePlan(plan);
                    this.setUsedBytes(this.result.getByteTotal());
                    for (IAEItemStack iAEItemStack : plan) {
                        IAEItemStack o = iAEItemStack.copy();
                        o.reset();
                        o.setStackSize(iAEItemStack.getStackSize());
                        IAEItemStack p = iAEItemStack.copy();
                        p.reset();
                        p.setStackSize(iAEItemStack.getCountRequestable());
                        IStorageGrid sg = (IStorageGrid)this.getGrid().getCache(IStorageGrid.class);
                        IMEMonitor<IAEItemStack> items = sg.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                        IAEItemStack m = null;
                        if (c != null && this.result.isSimulation()) {
                            m = o.copy();
                            if ((o = items.extractItems(o, Actionable.SIMULATE, this.getActionSource())) == null) {
                                o = m.copy();
                                o.setStackSize(0L);
                            }
                            m.setStackSize(m.getStackSize() - o.getStackSize());
                        }
                        if (o.getStackSize() > 0L) {
                            a.appendItem(o);
                        }
                        if (p.getStackSize() > 0L) {
                            b.appendItem(p);
                        }
                        if (c == null || m == null || m.getStackSize() <= 0L) continue;
                        c.appendItem(m);
                    }
                    for (IAEItemStack iAEItemStack : this.getListeners()) {
                        if (!(iAEItemStack instanceof class_1657)) continue;
                        NetworkHandler.instance().sendTo(a, (class_3222)iAEItemStack);
                        NetworkHandler.instance().sendTo(b, (class_3222)iAEItemStack);
                        if (c == null) continue;
                        NetworkHandler.instance().sendTo(c, (class_3222)iAEItemStack);
                    }
                }
                catch (IOException a) {
                }
            }
            catch (Throwable e) {
                this.getPlayerInv().field_7546.method_9203((class_2561)new class_2585("Error: " + e.toString()), class_156.field_25140);
                AELog.debug(e);
                this.setValidContainer(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    private IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        return h.getActionableNode().getGrid();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.getAvailableStorage() >= this.getUsedBytes() && !c.isBusy();
    }

    public void startJob() {
        Object originalGui = null;
        IActionHost ah = this.getActionHost();
        if (ah instanceof WirelessTerminalGuiObject) {
            originalGui = WirelessTermContainer.TYPE;
        }
        if (ah instanceof TerminalPart) {
            originalGui = MEMonitorableContainer.TYPE;
        }
        if (ah instanceof CraftingTerminalPart) {
            originalGui = CraftingTermContainer.TYPE;
        }
        if (ah instanceof PatternTerminalPart) {
            originalGui = PatternTermContainer.TYPE;
        }
        if (this.result != null && !this.isSimulation()) {
            ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
            ICraftingLink g = cc.submitJob(this.result, null, this.selectedCpu, true, this.getActionSrc());
            this.setAutoStart(false);
            if (g != null && originalGui != null && this.getLocator() != null) {
                ContainerOpener.openContainer(originalGui, this.getPlayerInventory().field_7546, this.getLocator());
            }
        }
    }

    private IActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInv().field_7546, (IActionHost)this.getTarget());
    }

    public void method_7603(class_1712 c) {
        super.method_7603(c);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public void method_7595(class_1657 par1PlayerEntity) {
        super.method_7595(par1PlayerEntity);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    private void onCPUSelectionChanged(CraftingCPURecord cpuRecord, boolean cpusAvailable) {
        boolean bl = this.noCPU = !cpusAvailable;
        if (cpuRecord == null) {
            this.cpuBytesAvail = 0L;
            this.cpuCoProcessors = 0;
            this.cpuName = null;
            this.selectedCpu = null;
        } else {
            this.cpuBytesAvail = cpuRecord.getSize();
            this.cpuCoProcessors = cpuRecord.getProcessors();
            this.cpuName = cpuRecord.getName();
            this.selectedCpu = cpuRecord.getCpu();
        }
    }

    public class_1937 getWorld() {
        return this.getPlayerInv().field_7546.field_6002;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public long getUsedBytes() {
        return this.bytesUsed;
    }

    private void setUsedBytes(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public long getCpuAvailableBytes() {
        return this.cpuBytesAvail;
    }

    public int getCpuCoProcessors() {
        return this.cpuCoProcessors;
    }

    public class_2561 getName() {
        return this.cpuName;
    }

    public boolean hasNoCPU() {
        return this.noCPU;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    private void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    private Future<ICraftingJob> getJob() {
        return this.job;
    }

    public void setJob(Future<ICraftingJob> job) {
        this.job = job;
    }

    static {
        helper = new ContainerHelper<CraftConfirmContainer, ITerminalHost>(CraftConfirmContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

