/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.CraftingBlockEntity;
import java.io.IOException;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1712;
import net.minecraft.class_2540;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class CraftingCPUContainer
extends AEBaseContainer
implements IMEMonitorHandlerReceiver<IAEItemStack> {
    public static class_3917<CraftingCPUContainer> TYPE;
    private static final ContainerHelper<CraftingCPUContainer, CraftingBlockEntity> helper;
    private final IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IGrid network;
    private CraftingCPUCluster monitor = null;
    @GuiSync(value=0)
    public long eta = -1L;

    private CraftingCPUContainer(int id, class_1661 ip, CraftingBlockEntity te) {
        this(TYPE, id, ip, te);
    }

    public CraftingCPUContainer(class_3917<?> containerType, int id, class_1661 ip, Object te) {
        super(containerType, id, ip, te);
        IActionHost host = (IActionHost)(te instanceof IActionHost ? te : null);
        this.network = host != null && host.getActionableNode() != null ? host.getActionableNode().getGrid() : null;
        if (te instanceof CraftingBlockEntity) {
            this.setCPU(((CraftingBlockEntity)te).getCluster());
        }
        if (this.getNetwork() == null && this.isServer()) {
            this.setValidContainer(false);
        }
    }

    public static CraftingCPUContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.getMonitor()) {
            return;
        }
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
        for (class_1712 g : this.getListeners()) {
            if (!(g instanceof class_1657)) continue;
            NetworkHandler.instance().sendTo(new ConfigValuePacket("CraftingStatus", "Clear"), (class_3222)g);
        }
        if (c instanceof CraftingCPUCluster) {
            this.monitor = (CraftingCPUCluster)c;
            this.list.resetStatus();
            this.getMonitor().getListOfItem(this.list, CraftingItemList.ALL);
            this.getMonitor().addListener(this, (Object)null);
            this.setEstimatedTime(0L);
        } else {
            this.monitor = null;
            this.setEstimatedTime(-1L);
        }
    }

    public void cancelCrafting() {
        if (this.getMonitor() != null) {
            this.getMonitor().cancel();
        }
        this.setEstimatedTime(-1L);
    }

    public void method_7603(class_1712 c) {
        super.method_7603(c);
        if (this.getListeners().isEmpty() && this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
    }

    @Override
    public void method_7623() {
        if (this.isServer() && this.getMonitor() != null && !this.list.isEmpty()) {
            try {
                if (this.getEstimatedTime() >= 0L) {
                    long elapsedTime = this.getMonitor().getElapsedTime();
                    double remainingItems = this.getMonitor().getRemainingItemCount();
                    double d = this.getMonitor().getStartItemCount();
                    long eta = (long)((double)elapsedTime / Math.max(1.0, d - remainingItems) * remainingItems);
                    this.setEstimatedTime(eta);
                }
                MEInventoryUpdatePacket a = new MEInventoryUpdatePacket(0);
                MEInventoryUpdatePacket b = new MEInventoryUpdatePacket(1);
                MEInventoryUpdatePacket c = new MEInventoryUpdatePacket(2);
                for (IAEItemStack iAEItemStack : this.list) {
                    a.appendItem(this.getMonitor().getItemStack(iAEItemStack, CraftingItemList.STORAGE));
                    b.appendItem(this.getMonitor().getItemStack(iAEItemStack, CraftingItemList.ACTIVE));
                    c.appendItem(this.getMonitor().getItemStack(iAEItemStack, CraftingItemList.PENDING));
                }
                this.list.resetStatus();
                for (IAEItemStack iAEItemStack : this.getListeners()) {
                    if (!(iAEItemStack instanceof class_1657)) continue;
                    if (!a.isEmpty()) {
                        NetworkHandler.instance().sendTo(a, (class_3222)iAEItemStack);
                    }
                    if (!b.isEmpty()) {
                        NetworkHandler.instance().sendTo(b, (class_3222)iAEItemStack);
                    }
                    if (c.isEmpty()) continue;
                    NetworkHandler.instance().sendTo(c, (class_3222)iAEItemStack);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.method_7623();
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource actionSource) {
        for (IAEItemStack is : change) {
            is = is.copy();
            is.setStackSize(1L);
            this.list.add(is);
        }
    }

    @Override
    public void onListUpdate() {
    }

    public long getEstimatedTime() {
        return this.eta;
    }

    private void setEstimatedTime(long eta) {
        this.eta = eta;
    }

    CraftingCPUCluster getMonitor() {
        return this.monitor;
    }

    IGrid getNetwork() {
        return this.network;
    }

    static {
        helper = new ContainerHelper<CraftingCPUContainer, CraftingBlockEntity>(CraftingCPUContainer::new, CraftingBlockEntity.class, SecurityPermissions.CRAFT).withContainerTitle(craftingTileEntity -> {
            CraftingCPUCluster cluster = craftingTileEntity.getCluster();
            if (cluster != null && cluster.getName() != null) {
                return cluster.getName();
            }
            return class_2585.field_24366;
        });
    }
}

