/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.storage.ITerminalHost;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.CraftingCPUContainer;
import appeng.container.implementations.CraftingCPUCycler;
import appeng.container.implementations.CraftingCPUCyclingContainer;
import appeng.container.implementations.CraftingCPURecord;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3917;

public class CraftingStatusContainer
extends CraftingCPUContainer
implements CraftingCPUCyclingContainer {
    public static class_3917<CraftingStatusContainer> TYPE;
    private static final ContainerHelper<CraftingStatusContainer, ITerminalHost> helper;
    private final CraftingCPUCycler cpuCycler = new CraftingCPUCycler(this::cpuMatches, this::onCPUSelectionChanged);
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public class_2561 cpuName;

    public static CraftingStatusContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public CraftingStatusContainer(int id, class_1661 ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
    }

    @Override
    public void method_7623() {
        IGrid network = this.getNetwork();
        if (this.isServer() && network != null) {
            this.cpuCycler.detectAndSendChanges(network);
        }
        super.method_7623();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.isBusy();
    }

    private void onCPUSelectionChanged(CraftingCPURecord cpuRecord, boolean cpusAvailable) {
        boolean bl = this.noCPU = !cpusAvailable;
        if (cpuRecord == null) {
            this.cpuName = null;
            this.setCPU(null);
        } else {
            this.cpuName = cpuRecord.getName();
            this.setCPU(cpuRecord.getCpu());
        }
    }

    @Override
    public void cycleSelectedCPU(boolean forward) {
        this.cpuCycler.cycleCpu(forward);
    }

    static {
        helper = new ContainerHelper<CraftingStatusContainer, ITerminalHost>(CraftingStatusContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

