/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.definitions.IItemDefinition;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.tile.misc.InscriberBlockEntity;
import appeng.tile.misc.InscriberRecipes;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class InscriberContainer
extends UpgradeableContainer
implements IProgressProvider {
    public static class_3917<InscriberContainer> TYPE;
    private static final ContainerHelper<InscriberContainer, InscriberBlockEntity> helper;
    private final InscriberBlockEntity ti;
    private final class_1735 top;
    private final class_1735 middle;
    private final class_1735 bottom;
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;

    public static InscriberContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public InscriberContainer(int id, class_1661 ip, InscriberBlockEntity te) {
        super(TYPE, id, ip, te);
        this.ti = te;
        FixedItemInv inv = te.getInternalInventory();
        RestrictedInputSlot top = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_PLATE, inv, 0, 45, 16, this.getPlayerInventory());
        top.setStackLimit(1);
        this.top = this.method_7621(top);
        RestrictedInputSlot bottom = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_PLATE, inv, 1, 45, 62, this.getPlayerInventory());
        bottom.setStackLimit(1);
        this.bottom = this.method_7621(bottom);
        RestrictedInputSlot middle = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.INSCRIBER_INPUT, inv, 2, 63, 39, this.getPlayerInventory());
        middle.setStackLimit(1);
        this.middle = this.method_7621(middle);
        this.method_7621(new OutputSlot(inv, 3, 113, 40, -1));
    }

    @Override
    protected int getHeight() {
        return 176;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 3;
    }

    @Override
    public void method_7623() {
        this.standardDetectAndSendChanges();
        if (this.isServer()) {
            this.maxProcessingTime = this.ti.getMaxProcessingTime();
            this.processingTime = this.ti.getProcessingTime();
        }
    }

    @Override
    public boolean isValidForSlot(class_1735 s, class_1799 is) {
        class_1799 top = this.ti.getInternalInventory().getInvStack(0);
        class_1799 bot = this.ti.getInternalInventory().getInvStack(1);
        if (s == this.middle) {
            IItemDefinition press = Api.instance().definitions().materials().namePress();
            if (press.isSameAs(top) || press.isSameAs(bot)) {
                return !press.isSameAs(is);
            }
            return InscriberRecipes.findRecipe(this.ti.method_10997(), is, top, bot, false) != null;
        }
        if (s == this.top && !bot.method_7960() || s == this.bottom && !top.method_7960()) {
            class_1799 otherSlot = s == this.top ? this.bottom.method_7677() : this.top.method_7677();
            IItemDefinition namePress = Api.instance().definitions().materials().namePress();
            if (namePress.isSameAs(otherSlot)) {
                return namePress.isSameAs(is);
            }
            return InscriberRecipes.isValidOptionalIngredientCombination(this.ti.method_10997(), is, otherSlot);
        }
        return true;
    }

    @Override
    public int getCurrentProgress() {
        return this.processingTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProcessingTime;
    }

    static {
        helper = new ContainerHelper<InscriberContainer, InscriberBlockEntity>(InscriberContainer::new, InscriberBlockEntity.class);
    }
}

