/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import alexiil.mc.lib.attributes.item.SingleItemSlot;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MEInterfaceUpdatePacket;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.EncodedPatternItem;
import appeng.parts.misc.InterfacePart;
import appeng.parts.reporting.InterfaceTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.InterfaceBlockEntity;
import appeng.util.InventoryAdaptor;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.WrapperCursorItemHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public final class InterfaceTerminalContainer
extends AEBaseContainer {
    public static class_3917<InterfaceTerminalContainer> TYPE;
    private static final ContainerHelper<InterfaceTerminalContainer, InterfaceTerminalPart> helper;
    private static long autoBase;
    private final Map<IInterfaceHost, InvTracker> diList = new HashMap<IInterfaceHost, InvTracker>();
    private final Map<Long, InvTracker> byId = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private class_2487 data = new class_2487();

    public static InterfaceTerminalContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public InterfaceTerminalContainer(int id, class_1661 ip, InterfaceTerminalPart anchor) {
        super(TYPE, id, ip, anchor);
        if (this.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 0, 140);
    }

    @Override
    public void method_7623() {
        IGridNode agn;
        if (this.isClient()) {
            return;
        }
        super.method_7623();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterface dual;
            InvTracker t;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(InterfaceBlockEntity.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)((Object)gn.getMachine())).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.name.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(InterfacePart.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)((Object)gn.getMachine())).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.name.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
                InvTracker inv = en.getValue();
                for (int x = 0; x < inv.server.getSlotCount(); ++x) {
                    if (!this.isDifferent(inv.server.getInvStack(x), inv.client.getInvStack(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.isEmpty()) {
            try {
                NetworkHandler.instance().sendTo(new MEInterfaceUpdatePacket(this.data), (class_3222)this.getPlayerInv().field_7546);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new class_2487();
        }
    }

    @Override
    public void doAction(class_3222 player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.byId.get(id);
        if (inv != null) {
            class_1799 is = inv.server.getInvStack(slot);
            boolean hasItemInHand = !player.field_7514.method_7399().method_7960();
            AdaptorFixedInv playerHand = new AdaptorFixedInv((FixedItemInv)new WrapperCursorItemHandler(player.field_7514));
            LimitedFixedItemInv limitedSlotInv = inv.server.createLimitedFixedInv();
            limitedSlotInv.getAllRule().filterInserts(this::isValidPattern);
            SingleItemSlot theSlot = limitedSlotInv.getSlot(slot);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        class_1799 inSlot = theSlot.get();
                        if (inSlot.method_7960()) {
                            player.field_7514.method_7396(theSlot.insert(player.field_7514.method_7399()));
                            break;
                        }
                        inSlot = inSlot.method_7972();
                        class_1799 inHand = player.field_7514.method_7399().method_7972();
                        theSlot.set(class_1799.field_8037);
                        player.field_7514.method_7396(class_1799.field_8037);
                        player.field_7514.method_7396(theSlot.insert(inHand.method_7972()));
                        if (player.field_7514.method_7399().method_7960()) {
                            player.field_7514.method_7396(inSlot);
                            break;
                        }
                        player.field_7514.method_7396(inHand);
                        theSlot.set(inSlot);
                        break;
                    }
                    theSlot.set(((InventoryAdaptor)playerHand).addItems(theSlot.get()));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        class_1799 extra = ((InventoryAdaptor)playerHand).removeItems(1, class_1799.field_8037, null);
                        if (!extra.method_7960()) {
                            extra = theSlot.insert(extra);
                        }
                        if (extra.method_7960()) break;
                        ((InventoryAdaptor)playerHand).addItems(extra);
                        break;
                    }
                    if (is.method_7960()) break;
                    class_1799 extra = theSlot.extract((is.method_7947() + 1) / 2);
                    if (!extra.method_7960()) {
                        extra = ((InventoryAdaptor)playerHand).addItems(extra);
                    }
                    if (extra.method_7960()) break;
                    theSlot.insert(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((class_1657)player);
                    theSlot.set(playerInv.addItems(theSlot.get()));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor((class_1657)player);
                    for (int x = 0; x < inv.server.getSlotCount(); ++x) {
                        ItemHandlerUtil.setStackInSlot(inv.server, x, playerInvAd.addItems(inv.server.getInvStack(x)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.method_7337() || hasItemInHand) break;
                    player.field_7514.method_7396(is.method_7960() ? class_1799.field_8037 : is.method_7972());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private boolean isValidPattern(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() instanceof EncodedPatternItem;
    }

    private void regenList(class_2487 data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterface dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(InterfaceBlockEntity.class)) {
                ih = (IInterfaceHost)((Object)gn.getMachine());
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(InterfacePart.class)) {
                ih = (IInterfaceHost)((Object)gn.getMachine());
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
        }
        data.method_10556("clear", true);
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
            InvTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.server.getSlotCount());
        }
    }

    private boolean isDifferent(class_1799 a, class_1799 b) {
        if (a.method_7960() && b.method_7960()) {
            return false;
        }
        if (a.method_7960() || b.method_7960()) {
            return true;
        }
        return !class_1799.method_7973((class_1799)a, (class_1799)b);
    }

    private void addItems(class_2487 data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        class_2487 tag = data.method_10562(name);
        if (tag.isEmpty()) {
            tag.method_10544("sortBy", inv.sortBy);
            tag.method_10582("un", class_2561.class_2562.method_10867((class_2561)inv.name));
        }
        for (int x = 0; x < length; ++x) {
            class_2487 itemNBT = new class_2487();
            class_1799 is = inv.server.getInvStack(x + offset);
            ItemHandlerUtil.setStackInSlot(inv.client, x + offset, is.method_7960() ? class_1799.field_8037 : is.method_7972());
            if (!is.method_7960()) {
                is.method_7953(itemNBT);
            }
            tag.method_10566(Integer.toString(x + offset), (class_2520)itemNBT);
        }
        data.method_10566(name, (class_2520)tag);
    }

    static /* synthetic */ long access$508() {
        return autoBase++;
    }

    static {
        helper = new ContainerHelper<InterfaceTerminalContainer, InterfaceTerminalPart>(InterfaceTerminalContainer::new, InterfaceTerminalPart.class, SecurityPermissions.BUILD);
        autoBase = Long.MIN_VALUE;
    }

    private static class InvTracker {
        private final long sortBy;
        private final long which = InterfaceTerminalContainer.access$508();
        private final class_2561 name;
        private final FixedItemInv client;
        private final FixedItemInv server;

        public InvTracker(DualityInterface dual, FixedItemInv patterns, class_2561 name) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, this.server.getSlotCount());
            this.name = name;
            this.sortBy = dual.getSortValue();
        }
    }
}

