/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import java.io.IOException;
import java.nio.BufferOverflowException;
import javax.annotation.Nonnull;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class MEMonitorableContainer
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEItemStack> {
    public static class_3917<MEMonitorableContainer> TYPE;
    private static final ContainerHelper<MEMonitorableContainer, ITerminalHost> helper;
    private final RestrictedInputSlot[] cellView = new RestrictedInputSlot[5];
    private final IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IConfigManager clientCM;
    private final ITerminalHost host;
    @GuiSync(value=99)
    public boolean canAccessViewCells = false;
    @GuiSync(value=98)
    public boolean hasPower = false;
    @GuiSync(value=100)
    public int activeCraftingJobs = -1;
    private IConfigManagerHost gui;
    private IConfigManager serverCM;
    private IGridNode networkNode;

    public static MEMonitorableContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public MEMonitorableContainer(int id, class_1661 ip, ITerminalHost monitorable) {
        this(TYPE, id, ip, monitorable, true);
    }

    public MEMonitorableContainer(class_3917<?> containerType, int id, class_1661 ip, ITerminalHost monitorable, boolean bindInventory) {
        super(containerType, id, ip, monitorable instanceof class_2586 ? (class_2586)monitorable : null, monitorable instanceof IPart ? (IPart)((Object)monitorable) : null, monitorable instanceof IGuiItemObject ? (IGuiItemObject)((Object)monitorable) : null);
        this.host = monitorable;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        if (this.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            this.monitor = monitorable.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (this.monitor != null) {
                IGridNode node;
                this.monitor.addListener(this, null);
                this.setCellInventory(this.monitor);
                if (monitorable instanceof IPortableCell) {
                    this.setPowerSource((IEnergySource)((Object)monitorable));
                } else if (monitorable instanceof IMEChest) {
                    this.setPowerSource((IEnergySource)((Object)monitorable));
                } else if ((monitorable instanceof IGridHost || monitorable instanceof IActionHost) && (node = monitorable instanceof IGridHost ? ((IGridHost)((Object)monitorable)).getGridNode(AEPartLocation.INTERNAL) : (monitorable instanceof IActionHost ? ((IActionHost)((Object)monitorable)).getActionableNode() : null)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource(new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        this.canAccessViewCells = false;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.VIEW_CELL, ((IViewCellStorage)((Object)monitorable)).getViewCellStorage(), y, 206, y * 18 + 8, this.getPlayerInventory());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.method_7621(this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    @Override
    public void method_7623() {
        if (this.isServer()) {
            if (this.monitor != this.host.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class))) {
                this.setValidContainer(false);
            }
            this.updateActiveCraftingJobs();
            for (Settings set : this.serverCM.getSettings()) {
                Enum<?> enum_;
                Enum<?> sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (enum_ = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (class_1712 crafter : this.getListeners()) {
                    if (!(crafter instanceof class_3222)) continue;
                    NetworkHandler.instance().sendTo(new ConfigValuePacket(set.name(), sideLocal.name()), (class_3222)crafter);
                }
            }
            if (!this.items.isEmpty()) {
                try {
                    IItemList<IAEItemStack> monitorCache = this.monitor.getStorageList();
                    MEInventoryUpdatePacket piu = new MEInventoryUpdatePacket();
                    for (IAEItemStack iAEItemStack : this.items) {
                        IAEItemStack send = monitorCache.findPrecise(iAEItemStack);
                        if (send == null) {
                            iAEItemStack.setStackSize(0L);
                            piu.appendItem(iAEItemStack);
                            continue;
                        }
                        piu.appendItem(send);
                    }
                    if (!piu.isEmpty()) {
                        this.items.resetStatus();
                        for (IAEItemStack iAEItemStack : this.getListeners()) {
                            if (!(iAEItemStack instanceof class_1657)) continue;
                            NetworkHandler.instance().sendTo(piu, (class_3222)iAEItemStack);
                        }
                    }
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
            }
            this.updatePowerStatus();
            boolean oldAccessible = this.canAccessViewCells;
            this.canAccessViewCells = this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldAccessible) {
                for (int y = 0; y < 5; ++y) {
                    if (this.cellView[y] == null) continue;
                    this.cellView[y].setAllowEdit(this.canAccessViewCells);
                }
            }
            super.method_7623();
        }
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("canAccessViewCells")) {
            for (int y = 0; y < 5; ++y) {
                if (this.cellView[y] == null) continue;
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
            }
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void method_7596(class_1712 c) {
        super.method_7596(c);
        this.queueInventory(c);
    }

    private void updateActiveCraftingJobs() {
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && this.host instanceof IActionHost) {
            hostNode = ((IActionHost)((Object)this.host)).getActionableNode();
        }
        IGrid grid = null;
        if (hostNode != null) {
            grid = hostNode.getGrid();
        }
        if (grid == null) {
            this.activeCraftingJobs = -1;
            return;
        }
        int activeJobs = 0;
        ICraftingGrid craftingGrid = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        for (ICraftingCPU cpus : craftingGrid.getCpus()) {
            if (!cpus.isBusy()) continue;
            ++activeJobs;
        }
        this.activeCraftingJobs = activeJobs;
    }

    private void queueInventory(class_1712 c) {
        if (this.isServer() && c instanceof class_1657 && this.monitor != null) {
            try {
                MEInventoryUpdatePacket piu = new MEInventoryUpdatePacket();
                IItemList<IAEItemStack> monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance().sendTo(piu, (class_3222)c);
                        piu = new MEInventoryUpdatePacket();
                        piu.appendItem(send);
                    }
                }
                NetworkHandler.instance().sendTo(piu, (class_3222)c);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    public void method_7603(class_1712 c) {
        super.method_7603(c);
        if (this.getListeners().isEmpty() && this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource source) {
        for (IAEItemStack is : change) {
            this.items.add(is);
        }
    }

    @Override
    public void onListUpdate() {
        for (class_1712 c : this.getListeners()) {
            this.queueInventory(c);
        }
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (this.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public class_1799[] getViewCells() {
        class_1799[] list = new class_1799[this.cellView.length];
        for (int x = 0; x < this.cellView.length; ++x) {
            list[x] = this.cellView[x].method_7677();
        }
        return list;
    }

    public RestrictedInputSlot getCellViewSlot(int index) {
        return this.cellView[index];
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    static {
        helper = new ContainerHelper<MEMonitorableContainer, ITerminalHost>(MEMonitorableContainer::new, ITerminalHost.class);
    }
}

