/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.interfaces.IInventorySlotAware;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class MEPortableCellContainer
extends MEMonitorableContainer {
    public static class_3917<MEPortableCellContainer> TYPE;
    private static final ContainerHelper<MEPortableCellContainer, IPortableCell> helper;
    private double powerMultiplier = 0.5;
    private final IPortableCell civ;
    private int ticks = 0;
    private final int slot;

    public static MEPortableCellContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public MEPortableCellContainer(int id, class_1661 ip, IPortableCell monitorable) {
        this(TYPE, id, ip, monitorable);
    }

    protected MEPortableCellContainer(class_3917<? extends MEPortableCellContainer> type, int id, class_1661 ip, IPortableCell monitorable) {
        super(type, id, ip, monitorable, false);
        if (monitorable instanceof IInventorySlotAware) {
            int slotIndex = ((IInventorySlotAware)((Object)monitorable)).getInventorySlot();
            this.lockPlayerInventorySlot(slotIndex);
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_7545);
        }
        this.civ = monitorable;
        this.bindPlayerInventory(ip, 0, 0);
    }

    @Override
    public void method_7623() {
        class_1799 currentItem;
        class_1799 class_17992 = currentItem = this.slot < 0 ? this.getPlayerInv().method_7391() : this.getPlayerInv().method_5438(this.slot);
        if (this.civ == null || currentItem.method_7960()) {
            this.setValidContainer(false);
        } else if (this.civ != null && !this.civ.getItemStack().method_7960() && currentItem != this.civ.getItemStack()) {
            if (class_1799.method_7987((class_1799)this.civ.getItemStack(), (class_1799)currentItem)) {
                this.getPlayerInv().method_5447(this.getPlayerInv().field_7545, this.civ.getItemStack());
            } else {
                this.setValidContainer(false);
            }
        }
        ++this.ticks;
        if (this.ticks > 10) {
            this.civ.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.ticks = 0;
        }
        super.method_7623();
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    static {
        helper = new ContainerHelper<MEPortableCellContainer, IPortableCell>(MEPortableCellContainer::new, IPortableCell.class);
    }
}

