/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class NetworkStatusContainer
extends AEBaseContainer {
    public static class_3917<NetworkStatusContainer> TYPE;
    private static final ContainerHelper<NetworkStatusContainer, INetworkTool> helper;
    @GuiSync(value=0)
    public long avgAddition;
    @GuiSync(value=1)
    public long powerUsage;
    @GuiSync(value=2)
    public long currentPower;
    @GuiSync(value=3)
    public long maxPower;
    private IGrid network;
    private int delay = 40;

    public static NetworkStatusContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public NetworkStatusContainer(int id, class_1661 ip, INetworkTool te) {
        super(TYPE, id, ip, null, null);
        IGridHost host = te.getGridHost();
        if (host != null) {
            this.findNode(host, AEPartLocation.INTERNAL);
            for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                this.findNode(host, d);
            }
        }
        if (this.network == null && this.isServer()) {
            this.setValidContainer(false);
        }
    }

    private void findNode(IGridHost host, AEPartLocation d) {
        IGridNode node;
        if (this.network == null && (node = host.getGridNode(d)) != null) {
            this.network = node.getGrid();
        }
    }

    @Override
    public void method_7623() {
        ++this.delay;
        if (this.isServer() && this.delay > 15 && this.network != null) {
            this.delay = 0;
            IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
            if (eg != null) {
                this.setAverageAddition((long)(100.0 * eg.getAvgPowerInjection()));
                this.setPowerUsage((long)(100.0 * eg.getAvgPowerUsage()));
                this.setCurrentPower((long)(100.0 * eg.getStoredPower()));
                this.setMaxPower((long)(100.0 * eg.getMaxStoredPower()));
            }
            try {
                MEInventoryUpdatePacket piu = new MEInventoryUpdatePacket();
                for (Class clazz : this.network.getMachinesClasses()) {
                    IItemList<AEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                    for (IGridNode iGridNode : this.network.getMachines(clazz)) {
                        IGridBlock blk = iGridNode.getGridBlock();
                        class_1799 is = blk.getMachineRepresentation();
                        if (is.method_7960()) continue;
                        AEItemStack ais = AEItemStack.fromItemStack(is);
                        ais.setStackSize(1L);
                        ais.setCountRequestable((long)(blk.getIdlePowerUsage() * 100.0));
                        list.add(ais);
                    }
                    for (IAEItemStack iAEItemStack : list) {
                        piu.appendItem(iAEItemStack);
                    }
                }
                for (Object object : this.getListeners()) {
                    if (!(object instanceof class_1657)) continue;
                    NetworkHandler.instance().sendTo(piu, (class_3222)object);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.method_7623();
    }

    public long getCurrentPower() {
        return this.currentPower;
    }

    private void setCurrentPower(long currentPower) {
        this.currentPower = currentPower;
    }

    public long getMaxPower() {
        return this.maxPower;
    }

    private void setMaxPower(long maxPower) {
        this.maxPower = maxPower;
    }

    public long getAverageAddition() {
        return this.avgAddition;
    }

    private void setAverageAddition(long avgAddition) {
        this.avgAddition = avgAddition;
    }

    public long getPowerUsage() {
        return this.powerUsage;
    }

    private void setPowerUsage(long powerUsage) {
        this.powerUsage = powerUsage;
    }

    static {
        helper = new ContainerHelper<NetworkStatusContainer, INetworkTool>(NetworkStatusContainer::new, INetworkTool.class);
    }
}

