/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.compat.FixedInventoryVanillaWrapper;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerLocator;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.slot.FakeCraftingMatrixSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalFakeSlot;
import appeng.container.slot.PatternOutputsSlot;
import appeng.container.slot.PatternTermSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.me.helpers.MachineSource;
import appeng.mixins.SlotMixin;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class PatternTermContainer
extends MEMonitorableContainer
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    public static class_3917<PatternTermContainer> TYPE;
    private static final ContainerHelper<PatternTermContainer, ITerminalHost> helper;
    private final PatternTerminalPart patternTerminal;
    private final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    private final FixedItemInv crafting;
    private final FakeCraftingMatrixSlot[] craftingSlots = new FakeCraftingMatrixSlot[9];
    private final OptionalFakeSlot[] outputSlots = new OptionalFakeSlot[3];
    private final PatternTermSlot craftSlot;
    private final RestrictedInputSlot patternSlotIN;
    private final RestrictedInputSlot patternSlotOUT;
    private final ICraftingHelper craftingHelper = Api.INSTANCE.crafting();
    private class_3955 currentRecipe;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;

    public static PatternTermContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public PatternTermContainer(int id, class_1661 ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, false);
        int y;
        this.patternTerminal = (PatternTerminalPart)monitorable;
        FixedItemInv patternInv = this.getPatternTerminal().getInventoryByName("pattern");
        FixedItemInv output = this.getPatternTerminal().getInventoryByName("output");
        this.crafting = this.getPatternTerminal().getInventoryByName("crafting");
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                FakeCraftingMatrixSlot fakeCraftingMatrixSlot = new FakeCraftingMatrixSlot(this.crafting, x + y * 3, 18 + x * 18, -76 + y * 18);
                this.craftingSlots[x + y * 3] = fakeCraftingMatrixSlot;
                this.method_7621(fakeCraftingMatrixSlot);
            }
        }
        this.craftSlot = new PatternTermSlot(ip.field_7546, this.getActionSource(), this.getPowerSource(), monitorable, this.crafting, patternInv, (FixedItemInv)this.cOut, 110, -58, this, 2, this);
        this.method_7621(this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (y = 0; y < 3; ++y) {
            this.outputSlots[y] = new PatternOutputsSlot(output, this, y, 110, -76 + y * 18, 0, 0, 1);
            this.method_7621(this.outputSlots[y]);
            this.outputSlots[y].setRenderDisabled(false);
            this.outputSlots[y].setIIcon(-1);
        }
        this.patternSlotIN = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getPlayerInventory());
        this.method_7621(this.patternSlotIN);
        this.patternSlotOUT = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getPlayerInventory());
        this.method_7621(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
        this.updateOrderOfOutputSlots();
    }

    private void setSlotX(class_1735 s, int x) {
        ((SlotMixin)s).setX(x);
    }

    private void updateOrderOfOutputSlots() {
        if (!this.isCraftingMode()) {
            this.setSlotX(this.craftSlot, -9000);
            for (int y = 0; y < 3; ++y) {
                this.setSlotX(this.outputSlots[y], this.outputSlots[y].getX());
            }
        } else {
            this.setSlotX(this.craftSlot, this.craftSlot.getX());
            for (int y = 0; y < 3; ++y) {
                this.setSlotX(this.outputSlots[y], -9000);
            }
        }
    }

    public void method_7619(int slotID, class_1799 stack) {
        super.method_7619(slotID, stack);
        this.getAndUpdateOutput();
    }

    private class_1799 getAndUpdateOutput() {
        class_1937 world = this.getPlayerInv().field_7546.field_6002;
        class_1715 ic = new class_1715((class_1703)this, 3, 3);
        for (int x = 0; x < ic.method_5439(); ++x) {
            ic.method_5447(x, this.crafting.getInvStack(x));
        }
        if (this.currentRecipe == null || !this.currentRecipe.method_8115((class_1263)ic, world)) {
            this.currentRecipe = world.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, world).orElse(null);
        }
        class_1799 is = this.currentRecipe == null ? class_1799.field_8037 : this.currentRecipe.method_8116((class_1263)ic);
        this.cOut.forceSetInvStack(0, is);
        return is;
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
    }

    public void encode() {
        class_1799 output = this.patternSlotOUT.method_7677();
        class_1799[] in = this.getInputs();
        class_1799[] out = this.getOutputs();
        if (in == null || out == null || this.isCraftingMode() && this.currentRecipe == null) {
            return;
        }
        if (!output.method_7960() && !this.craftingHelper.isEncodedPattern(output)) {
            return;
        }
        if (output.method_7960()) {
            output = this.patternSlotIN.method_7677();
            if (output.method_7960() || !this.isPattern(output)) {
                return;
            }
            output.method_7939(output.method_7947() - 1);
            if (output.method_7947() == 0) {
                this.patternSlotIN.method_7673(class_1799.field_8037);
            }
            output = null;
        }
        output = this.isCraftingMode() ? this.craftingHelper.encodeCraftingPattern(output, this.currentRecipe, in, out[0], this.isSubstitute()) : this.craftingHelper.encodeProcessingPattern(output, in, out);
        this.patternSlotOUT.method_7673(output);
    }

    private class_1799[] getInputs() {
        class_1799[] input = new class_1799[9];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].method_7677();
            if (input[x].method_7960()) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private class_1799[] getOutputs() {
        if (this.isCraftingMode()) {
            class_1799 out = this.getAndUpdateOutput();
            if (!out.method_7960() && out.method_7947() > 0) {
                return new class_1799[]{out};
            }
        } else {
            boolean hasValue = false;
            class_1799[] list = new class_1799[3];
            for (int i = 0; i < this.outputSlots.length; ++i) {
                class_1799 out;
                list[i] = out = this.outputSlots[i].method_7677();
                if (out.method_7960()) continue;
                hasValue = true;
            }
            if (hasValue) {
                return list;
            }
        }
        return null;
    }

    private boolean isPattern(class_1799 output) {
        if (output.method_7960()) {
            return false;
        }
        IDefinitions definitions = Api.instance().definitions();
        return definitions.materials().blankPattern().isSameAs(output);
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return this.isServer() ? !this.getPatternTerminal().isCraftingRecipe() : !this.isCraftingMode();
        }
        if (idx == 2) {
            return this.isServer() ? this.getPatternTerminal().isCraftingRecipe() : this.isCraftingMode();
        }
        return false;
    }

    public void craftOrGetItem(PatternSlotPacket packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.getCellInventory() != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            InventoryAdaptor inv = new AdaptorFixedInv((FixedItemInv)new WrapperCursorItemHandler(this.getPlayerInv().field_7546.field_7514));
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(this.getPlayerInv().field_7546);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (!inv.simulateAdd(out.createItemStack()).method_7960()) {
                return;
            }
            IAEItemStack extracted = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), out, this.getActionSource());
            class_1657 p = this.getPlayerInv().field_7546;
            if (extracted != null) {
                inv.addItems(extracted.createItemStack());
                if (p instanceof class_3222) {
                    this.updateHeld((class_3222)p);
                }
                this.method_7623();
                return;
            }
            class_1715 ic = new class_1715((class_1703)new ContainerNull(), 3, 3);
            class_1715 real = new class_1715((class_1703)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.method_5447(x, packetPatternSlot.pattern[x] == null ? class_1799.field_8037 : packetPatternSlot.pattern[x].createItemStack());
            }
            class_1860 r = p.field_6002.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, p.field_6002).orElse(null);
            if (r == null) {
                return;
            }
            IMEMonitor<IAEItemStack> storage = this.getPatternTerminal().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IItemList<IAEItemStack> all = storage.getStorageList();
            class_1799 is = r.method_8116((class_1263)ic);
            for (int x = 0; x < ic.method_5439(); ++x) {
                if (ic.method_5438(x).method_7960()) continue;
                class_1799 pulled = Platform.extractItemsByRecipe(this.getPowerSource(), this.getActionSource(), storage, p.field_6002, (class_1860<class_1715>)r, is, ic, ic.method_5438(x), x, all, Actionable.MODULATE, ViewCellItem.createFilter(this.getViewCells()));
                real.method_5447(x, pulled);
            }
            class_1860 rr = p.field_6002.method_8433().method_8132(class_3956.field_17545, (class_1263)real, p.field_6002).orElse(null);
            if (rr == r && Platform.itemComparisons().isSameItem(rr.method_8116((class_1263)real), is)) {
                class_1731 craftingResult = new class_1731();
                craftingResult.method_7662(rr);
                class_1734 sc = new class_1734(p, real, (class_1263)craftingResult, 0, 0, 0);
                sc.method_7667(p, is);
                for (int x = 0; x < real.method_5439(); ++x) {
                    class_1799 failed = playerInv.addItems(real.method_5438(x));
                    if (failed.method_7960()) continue;
                    p.method_7328(failed, false);
                }
                inv.addItems(is);
                if (p instanceof class_3222) {
                    this.updateHeld((class_3222)p);
                }
                this.method_7623();
            } else {
                for (int x = 0; x < real.method_5439(); ++x) {
                    class_1799 failed = real.method_5438(x);
                    if (failed.method_7960()) continue;
                    this.getCellInventory().injectItems(AEItemStack.fromItemStack(failed), Actionable.MODULATE, new MachineSource(this.getPatternTerminal()));
                }
            }
        }
    }

    @Override
    public void method_7623() {
        super.method_7623();
        if (this.isServer()) {
            if (this.isCraftingMode() != this.getPatternTerminal().isCraftingRecipe()) {
                this.setCraftingMode(this.getPatternTerminal().isCraftingRecipe());
                this.updateOrderOfOutputSlots();
            }
            this.substitute = this.patternTerminal.isSubstitution();
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void onSlotChange(class_1735 s) {
        if (s == this.patternSlotOUT && this.isServer()) {
            for (class_1712 listener : this.getListeners()) {
                for (int i = 0; i < this.field_7761.size(); ++i) {
                    class_1735 slot = (class_1735)this.field_7761.get(i);
                    if (!(slot instanceof OptionalFakeSlot) && !(slot instanceof FakeCraftingMatrixSlot)) continue;
                    listener.method_7635((class_1703)this, i, slot.method_7677());
                }
                if (!(listener instanceof class_3222)) continue;
                ((class_3222)listener).field_13991 = false;
            }
            this.method_7623();
        }
        if (s == this.craftSlot && this.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void clear() {
        for (FakeCraftingMatrixSlot fakeCraftingMatrixSlot : this.craftingSlots) {
            fakeCraftingMatrixSlot.method_7673(class_1799.field_8037);
        }
        for (FakeSlot fakeSlot : this.outputSlots) {
            fakeSlot.method_7673(class_1799.field_8037);
        }
        this.method_7623();
        this.getAndUpdateOutput();
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("player")) {
            return new FixedInventoryVanillaWrapper((class_1263)this.getPlayerInventory());
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public void toggleSubstitute() {
        this.substitute = !this.substitute;
        this.method_7623();
        this.getAndUpdateOutput();
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    private void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    public PatternTerminalPart getPatternTerminal() {
        return this.patternTerminal;
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        this.substitute = substitute;
    }

    static {
        helper = new ContainerHelper<PatternTermContainer, ITerminalHost>(PatternTermContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

