/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPart;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.helpers.IPriorityHost;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3917;

public class PriorityContainer
extends AEBaseContainer {
    public static class_3917<PriorityContainer> TYPE;
    private static final ContainerHelper<PriorityContainer, IPriorityHost> helper;
    private final IPriorityHost priHost;
    private int priorityValue;

    public static PriorityContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf, (host, container, buffer) -> {
            container.priorityValue = buffer.method_10816();
        });
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator, (host, buffer) -> buffer.method_10804(host.getPriority()));
    }

    public PriorityContainer(int id, class_1661 ip, IPriorityHost te) {
        super(TYPE, id, ip, (class_2586)(te instanceof class_2586 ? te : null), (IPart)((Object)(te instanceof IPart ? te : null)));
        this.priHost = te;
        this.priorityValue = te.getPriority();
    }

    public void setPriority(int newValue) {
        if (newValue != this.priorityValue) {
            if (this.isClient()) {
                this.priorityValue = newValue;
                NetworkHandler.instance().sendToServer(new ConfigValuePacket("PriorityHost.Priority", String.valueOf(newValue)));
            } else {
                this.priHost.setPriority(newValue);
                this.priorityValue = newValue;
            }
        }
    }

    @Override
    public void method_7623() {
        super.method_7623();
        this.verifyPermissions(SecurityPermissions.BUILD, false);
    }

    public int getPriorityValue() {
        return this.priorityValue;
    }

    public IPriorityHost getPriorityHost() {
        return this.priHost;
    }

    static {
        helper = new ContainerHelper<PriorityContainer, IPriorityHost>(PriorityContainer::new, IPriorityHost.class, SecurityPermissions.BUILD);
    }
}

