/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.SecurityPermissions;
import appeng.api.features.INetworkEncodable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.storage.ITerminalHost;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.SecurityStationBlockEntity;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class SecurityStationContainer
extends MEMonitorableContainer
implements IAEAppEngInventory {
    public static class_3917<SecurityStationContainer> TYPE;
    private static final ContainerHelper<SecurityStationContainer, ITerminalHost> helper;
    private final RestrictedInputSlot configSlot;
    private final AppEngInternalInventory wirelessEncoder = new AppEngInternalInventory(this, 2);
    private final RestrictedInputSlot wirelessIn;
    private final OutputSlot wirelessOut;
    private final SecurityStationBlockEntity securityBox;
    @GuiSync(value=0)
    public int permissionMode = 0;

    public SecurityStationContainer(int id, class_1661 ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, false);
        this.securityBox = (SecurityStationBlockEntity)monitorable;
        this.configSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BIOMETRIC_CARD, (FixedItemInv)this.securityBox.getConfigSlot(), 0, 37, -33, ip);
        this.method_7621(this.configSlot);
        this.wirelessIn = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODABLE_ITEM, (FixedItemInv)this.wirelessEncoder, 0, 212, 10, ip);
        this.method_7621(this.wirelessIn);
        this.wirelessOut = new OutputSlot((FixedItemInv)this.wirelessEncoder, 1, 212, 68, -1);
        this.method_7621(this.wirelessOut);
        this.bindPlayerInventory(ip, 0, 0);
    }

    public static SecurityStationContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public void toggleSetting(String value, class_1657 player) {
        try {
            SecurityPermissions permission = SecurityPermissions.valueOf(value);
            class_1799 a = this.configSlot.method_7677();
            if (!a.method_7960() && a.method_7909() instanceof IBiometricCard) {
                IBiometricCard bc = (IBiometricCard)a.method_7909();
                if (bc.hasPermission(a, permission)) {
                    bc.removePermission(a, permission);
                } else {
                    bc.addPermission(a, permission);
                }
            }
        }
        catch (EnumConstantNotPresentException enumConstantNotPresentException) {
            // empty catch block
        }
    }

    @Override
    public void method_7623() {
        this.verifyPermissions(SecurityPermissions.SECURITY, false);
        this.setPermissionMode(0);
        class_1799 a = this.configSlot.method_7677();
        if (!a.method_7960() && a.method_7909() instanceof IBiometricCard) {
            IBiometricCard bc = (IBiometricCard)a.method_7909();
            for (SecurityPermissions sp : bc.getPermissions(a)) {
                this.setPermissionMode(this.getPermissionMode() | 1 << sp.ordinal());
            }
        }
        this.updatePowerStatus();
        super.method_7623();
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.wirelessIn.method_7681()) {
            player.method_7328(this.wirelessIn.method_7677(), false);
        }
        if (this.wirelessOut.method_7681()) {
            player.method_7328(this.wirelessOut.method_7677(), false);
        }
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
        if (!this.wirelessOut.method_7681() && this.wirelessIn.method_7681()) {
            IWirelessTermHandler wTermHandler;
            class_1799 term = this.wirelessIn.method_7677().method_7972();
            INetworkEncodable networkEncodable = null;
            if (term.method_7909() instanceof INetworkEncodable) {
                networkEncodable = (INetworkEncodable)term.method_7909();
            }
            if ((wTermHandler = Api.instance().registries().wireless().getWirelessTerminalHandler(term)) != null) {
                networkEncodable = wTermHandler;
            }
            if (networkEncodable != null) {
                networkEncodable.setEncryptionKey(term, String.valueOf(this.securityBox.getSecurityKey()), "");
                this.wirelessIn.method_7673(class_1799.field_8037);
                this.wirelessOut.method_7673(term);
                for (class_1712 listener : this.getListeners()) {
                    listener.method_7635((class_1703)this, this.field_7761.indexOf((Object)this.wirelessIn), this.wirelessIn.method_7677());
                    listener.method_7635((class_1703)this, this.field_7761.indexOf((Object)this.wirelessOut), this.wirelessOut.method_7677());
                }
            }
        }
    }

    public int getPermissionMode() {
        return this.permissionMode;
    }

    private void setPermissionMode(int permissionMode) {
        this.permissionMode = permissionMode;
    }

    static {
        helper = new ContainerHelper<SecurityStationContainer, ITerminalHost>(SecurityStationContainer::new, ITerminalHost.class, SecurityPermissions.SECURITY);
    }
}

