/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.spatial.SpatialIOPortBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class SpatialIOPortContainer
extends AEBaseContainer {
    public static class_3917<SpatialIOPortContainer> TYPE;
    private static final ContainerHelper<SpatialIOPortContainer, SpatialIOPortBlockEntity> helper;
    @GuiSync(value=0)
    public long currentPower;
    @GuiSync(value=1)
    public long maxPower;
    @GuiSync(value=2)
    public long reqPower;
    @GuiSync(value=3)
    public long eff;
    private IGrid network;
    private int delay = 40;
    @GuiSync(value=31)
    public int xSize;
    @GuiSync(value=32)
    public int ySize;
    @GuiSync(value=33)
    public int zSize;

    public SpatialIOPortContainer(int id, class_1661 ip, SpatialIOPortBlockEntity spatialIOPort) {
        super(TYPE, id, ip, spatialIOPort, null);
        if (this.isServer()) {
            this.network = spatialIOPort.getGridNode(AEPartLocation.INTERNAL).getGrid();
        }
        this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.SPATIAL_STORAGE_CELLS, spatialIOPort.getInternalInventory(), 0, 52, 48, this.getPlayerInventory()));
        this.method_7621(new OutputSlot(spatialIOPort.getInternalInventory(), 1, 113, 48, RestrictedInputSlot.PlacableItemType.SPATIAL_STORAGE_CELLS.IIcon));
        this.bindPlayerInventory(ip, 0, 115);
    }

    public static SpatialIOPortContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    @Override
    public void method_7623() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            ++this.delay;
            if (this.delay > 15 && this.network != null) {
                this.delay = 0;
                IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
                ISpatialCache sc = (ISpatialCache)this.network.getCache(ISpatialCache.class);
                if (eg != null) {
                    this.setCurrentPower((long)(100.0 * eg.getStoredPower()));
                    this.setMaxPower((long)(100.0 * eg.getMaxStoredPower()));
                    this.setRequiredPower((long)(100.0 * (double)sc.requiredPower()));
                    this.setEfficency((long)(100.0f * sc.currentEfficiency()));
                    DimensionalCoord min = sc.getMin();
                    DimensionalCoord max = sc.getMax();
                    if (min != null && max != null && sc.isValidRegion()) {
                        this.xSize = sc.getMax().x - sc.getMin().x - 1;
                        this.ySize = sc.getMax().y - sc.getMin().y - 1;
                        this.zSize = sc.getMax().z - sc.getMin().z - 1;
                    } else {
                        this.xSize = 0;
                        this.ySize = 0;
                        this.zSize = 0;
                    }
                }
            }
        }
        super.method_7623();
    }

    public long getCurrentPower() {
        return this.currentPower;
    }

    private void setCurrentPower(long currentPower) {
        this.currentPower = currentPower;
    }

    public long getMaxPower() {
        return this.maxPower;
    }

    private void setMaxPower(long maxPower) {
        this.maxPower = maxPower;
    }

    public long getRequiredPower() {
        return this.reqPower;
    }

    private void setRequiredPower(long reqPower) {
        this.reqPower = reqPower;
    }

    public long getEfficency() {
        return this.eff;
    }

    private void setEfficency(long eff) {
        this.eff = eff;
    }

    static {
        helper = new ContainerHelper<SpatialIOPortContainer, SpatialIOPortBlockEntity>(SpatialIOPortContainer::new, SpatialIOPortBlockEntity.class, SecurityPermissions.BUILD);
    }
}

