/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.parts.IPart;
import appeng.api.util.IConfigManager;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.FakeTypeOnlySlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalFakeSlot;
import appeng.container.slot.OptionalTypeOnlyFakeSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.tools.NetworkToolItem;
import appeng.parts.automation.ExportBusPart;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3917;

public class UpgradeableContainer
extends AEBaseContainer
implements IOptionalSlotHost {
    public static class_3917<UpgradeableContainer> TYPE;
    private static final ContainerHelper<UpgradeableContainer, IUpgradeableHost> helper;
    private final IUpgradeableHost upgradeable;
    @GuiSync(value=0)
    public RedstoneMode rsMode = RedstoneMode.IGNORE;
    @GuiSync(value=1)
    public FuzzyMode fzMode = FuzzyMode.IGNORE_ALL;
    @GuiSync(value=5)
    public YesNo cMode = YesNo.NO;
    @GuiSync(value=6)
    public SchedulingMode schedulingMode = SchedulingMode.DEFAULT;
    private int tbSlot;
    private NetworkToolViewer tbInventory;

    public static UpgradeableContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public UpgradeableContainer(int id, class_1661 ip, IUpgradeableHost te) {
        this(TYPE, id, ip, te);
    }

    public UpgradeableContainer(class_3917<?> containerType, int id, class_1661 ip, IUpgradeableHost te) {
        super(containerType, id, ip, (class_2586)(te instanceof class_2586 ? te : null), (IPart)((Object)(te instanceof IPart ? te : null)));
        this.upgradeable = te;
        class_1937 w = null;
        int xCoord = 0;
        int yCoord = 0;
        int zCoord = 0;
        if (te instanceof class_2586) {
            class_2586 myTile = (class_2586)te;
            w = myTile.method_10997();
            xCoord = myTile.method_11016().method_10263();
            yCoord = myTile.method_11016().method_10264();
            zCoord = myTile.method_11016().method_10260();
        }
        if (te instanceof IPart) {
            class_2586 mk = te.getTile();
            w = mk.method_10997();
            xCoord = mk.method_11016().method_10263();
            yCoord = mk.method_11016().method_10264();
            zCoord = mk.method_11016().method_10260();
        }
        class_1661 pi = this.getPlayerInv();
        for (int x = 0; x < pi.method_5439(); ++x) {
            class_1799 pii = pi.method_5438(x);
            if (pii.method_7960() || !(pii.method_7909() instanceof NetworkToolItem)) continue;
            this.lockPlayerInventorySlot(x);
            this.tbSlot = x;
            this.tbInventory = (NetworkToolViewer)((IGuiItem)pii.method_7909()).getGuiObject(pii, x, w, new class_2338(xCoord, yCoord, zCoord));
            break;
        }
        if (this.hasToolbox()) {
            for (int v = 0; v < 3; ++v) {
                for (int u = 0; u < 3; ++u) {
                    this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, this.tbInventory.getInternalInventory(), u + v * 3, 186 + u * 18, this.getHeight() - 82 + v * 18, this.getPlayerInventory()).setPlayerSide());
                }
            }
        }
        this.setupConfig();
        this.bindPlayerInventory(ip, 0, this.getHeight() - 82);
    }

    public boolean hasToolbox() {
        return this.tbInventory != null;
    }

    protected int getHeight() {
        return 184;
    }

    protected void setupConfig() {
        this.setupUpgrades();
        FixedItemInv inv = this.getUpgradeable().getInventoryByName("config");
        int y = 40;
        int x = 80;
        this.method_7621(new FakeTypeOnlySlot(inv, 0, 80, 40));
        if (this.supportCapacity()) {
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 1, 80, 40, -1, 0, 1));
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 2, 80, 40, 1, 0, 1));
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 3, 80, 40, 0, -1, 1));
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 4, 80, 40, 0, 1, 1));
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 5, 80, 40, -1, -1, 2));
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 6, 80, 40, 1, -1, 2));
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 7, 80, 40, -1, 1, 2));
            this.method_7621(new OptionalTypeOnlyFakeSlot(inv, this, 8, 80, 40, 1, 1, 2));
        }
    }

    protected void setupUpgrades() {
        FixedItemInv upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        if (this.availableUpgrades() > 0) {
            this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 1) {
            this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 2) {
            this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getPlayerInventory()).setNotDraggable());
        }
        if (this.availableUpgrades() > 3) {
            this.method_7621(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getPlayerInventory()).setNotDraggable());
        }
    }

    protected boolean supportCapacity() {
        return true;
    }

    public int availableUpgrades() {
        return 4;
    }

    @Override
    public void method_7623() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            IConfigManager cm = this.getUpgradeable().getConfigManager();
            this.loadSettingsFromHost(cm);
        }
        this.checkToolbox();
        for (Object o : this.field_7761) {
            OptionalFakeSlot fs;
            if (!(o instanceof OptionalFakeSlot) || (fs = (OptionalFakeSlot)o).isSlotEnabled() || fs.getDisplayStack().method_7960()) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
        this.setRedStoneMode((RedstoneMode)cm.getSetting(Settings.REDSTONE_CONTROLLED));
        if (this.getUpgradeable() instanceof ExportBusPart) {
            this.setCraftingMode((YesNo)cm.getSetting(Settings.CRAFT_ONLY));
            this.setSchedulingMode((SchedulingMode)cm.getSetting(Settings.SCHEDULING_MODE));
        }
    }

    protected void checkToolbox() {
        class_1799 currentItem;
        if (this.hasToolbox() && (currentItem = this.getPlayerInv().method_5438(this.tbSlot)) != this.tbInventory.getItemStack()) {
            if (!currentItem.method_7960()) {
                if (class_1799.method_7987((class_1799)this.tbInventory.getItemStack(), (class_1799)currentItem)) {
                    this.getPlayerInv().method_5447(this.tbSlot, this.tbInventory.getItemStack());
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.setValidContainer(false);
            }
        }
    }

    protected void standardDetectAndSendChanges() {
        super.method_7623();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        if (idx == 1 && upgrades > 0) {
            return true;
        }
        return idx == 2 && upgrades > 1;
    }

    public FuzzyMode getFuzzyMode() {
        return this.fzMode;
    }

    public void setFuzzyMode(FuzzyMode fzMode) {
        this.fzMode = fzMode;
    }

    public YesNo getCraftingMode() {
        return this.cMode;
    }

    public void setCraftingMode(YesNo cMode) {
        this.cMode = cMode;
    }

    public RedstoneMode getRedStoneMode() {
        return this.rsMode;
    }

    public void setRedStoneMode(RedstoneMode rsMode) {
        this.rsMode = rsMode;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    private void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    protected IUpgradeableHost getUpgradeable() {
        return this.upgradeable;
    }

    static {
        helper = new ContainerHelper<UpgradeableContainer, IUpgradeableHost>(UpgradeableContainer::new, IUpgradeableHost.class, SecurityPermissions.BUILD);
    }
}

