/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.SingleItemSlot;
import appeng.container.AEBaseContainer;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class AppEngSlot
extends class_1735 {
    private static final class_1263 EMPTY_INVENTORY = new class_1277(0);
    private final FixedItemInv itemHandler;
    private final SingleItemSlot backingSlot;
    private final int invSlot;
    private final int defX;
    private final int defY;
    private boolean isDraggable = true;
    private boolean isPlayerSide = false;
    private AEBaseContainer myContainer = null;
    private int IIcon = -1;
    private CalculatedValidity isValid;
    private boolean isDisplay = false;

    public AppEngSlot(FixedItemInv inv, int invSlot, int x, int y) {
        super(EMPTY_INVENTORY, invSlot, x, y);
        this.itemHandler = inv;
        this.invSlot = invSlot;
        this.backingSlot = inv.getSlot(invSlot);
        this.defX = x;
        this.defY = y;
        this.setIsValid(CalculatedValidity.NotAvailable);
    }

    public class_1735 setNotDraggable() {
        this.setDraggable(false);
        return this;
    }

    public class_1735 setPlayerSide() {
        this.isPlayerSide = true;
        return this;
    }

    public String getTooltip() {
        return null;
    }

    public void clearStack() {
        this.backingSlot.set(class_1799.field_8037);
    }

    public boolean method_7680(@Nonnull class_1799 stack) {
        if (this.isSlotEnabled()) {
            return this.backingSlot.isValid(stack);
        }
        return false;
    }

    @Nonnull
    public class_1799 method_7677() {
        if (!this.isSlotEnabled()) {
            return class_1799.field_8037;
        }
        if (this.invSlot >= this.itemHandler.getSlotCount()) {
            return class_1799.field_8037;
        }
        if (this.isDisplay()) {
            this.setDisplay(false);
            return this.getDisplayStack();
        }
        return this.backingSlot.get();
    }

    public void method_7673(class_1799 stack) {
        if (this.isSlotEnabled()) {
            this.backingSlot.set(stack);
            this.method_7668();
        }
    }

    private void notifyContainerSlotChanged() {
        if (this.getContainer() != null) {
            this.getContainer().onSlotChange(this);
        }
    }

    public void method_7668() {
        super.method_7668();
        this.setIsValid(CalculatedValidity.NotAvailable);
        this.notifyContainerSlotChanged();
    }

    public int method_7675() {
        return this.backingSlot.getMaxAmount(class_1799.field_8037);
    }

    public int method_7676(@Nonnull class_1799 stack) {
        return Math.min(this.method_7675(), stack.method_7914());
    }

    public boolean method_7674(class_1657 player) {
        if (this.isSlotEnabled()) {
            return this.backingSlot.couldExtractAnything();
        }
        return false;
    }

    @Nonnull
    public class_1799 method_7671(int amount) {
        return this.backingSlot.extract(amount);
    }

    public boolean method_7681() {
        return !this.backingSlot.get().method_7960();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_7682() {
        return this.isSlotEnabled();
    }

    public boolean isSlotEnabled() {
        return true;
    }

    public class_1799 getDisplayStack() {
        return this.backingSlot.get();
    }

    public float getOpacityOfIcon() {
        return 0.4f;
    }

    public boolean renderIconWithItem() {
        return false;
    }

    public int getIcon() {
        return this.getIIcon();
    }

    public boolean isPlayerSide() {
        return this.isPlayerSide;
    }

    public boolean shouldDisplay() {
        return this.isSlotEnabled();
    }

    public int getX() {
        return this.defX;
    }

    public int getY() {
        return this.defY;
    }

    private int getIIcon() {
        return this.IIcon;
    }

    public void setIIcon(int iIcon) {
        this.IIcon = iIcon;
    }

    private boolean isDisplay() {
        return this.isDisplay;
    }

    public void setDisplay(boolean isDisplay) {
        this.isDisplay = isDisplay;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    private void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    void setPlayerSide(boolean isPlayerSide) {
        this.isPlayerSide = isPlayerSide;
    }

    public CalculatedValidity getIsValid() {
        return this.isValid;
    }

    public void setIsValid(CalculatedValidity isValid) {
        this.isValid = isValid;
    }

    protected AEBaseContainer getContainer() {
        return this.myContainer;
    }

    public void setContainer(AEBaseContainer myContainer) {
        this.myContainer = myContainer;
    }

    public static enum CalculatedValidity {
        NotAvailable,
        Valid,
        Invalid;

    }
}

