/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.core.Api;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3956;

public class CraftingTermSlot
extends AppEngCraftingSlot {
    private final FixedItemInv craftInv;
    private final FixedItemInv pattern;
    private final IActionSource mySrc;
    private final IEnergySource energySrc;
    private final IStorageMonitorable storage;
    private final IContainerCraftingPacket container;

    public CraftingTermSlot(class_1657 player, IActionSource mySrc, IEnergySource energySrc, IStorageMonitorable storage, FixedItemInv cMatrix, FixedItemInv secondMatrix, FixedItemInv output, int x, int y, IContainerCraftingPacket ccp) {
        super(player, cMatrix, output, 0, x, y);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.container = ccp;
    }

    public FixedItemInv getCraftingMatrix() {
        return this.craftInv;
    }

    @Override
    public boolean method_7674(class_1657 player) {
        return false;
    }

    @Override
    public class_1799 method_7667(class_1657 p, class_1799 is) {
        return is;
    }

    public void doClick(InventoryAction action, class_1657 who) {
        if (this.method_7677().method_7960()) {
            return;
        }
        if (Platform.isClient()) {
            return;
        }
        IMEMonitor<IAEItemStack> inv = this.storage.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        int howManyPerCraft = this.method_7677().method_7947();
        int maxTimesToCraft = 0;
        InventoryAdaptor ia = null;
        if (action == InventoryAction.CRAFT_SHIFT) {
            ia = InventoryAdaptor.getAdaptor(who);
            maxTimesToCraft = (int)Math.floor((double)this.method_7677().method_7914() / (double)howManyPerCraft);
        } else if (action == InventoryAction.CRAFT_STACK) {
            ia = new AdaptorFixedInv((FixedItemInv)new WrapperCursorItemHandler(who.field_7514));
            maxTimesToCraft = (int)Math.floor((double)this.method_7677().method_7914() / (double)howManyPerCraft);
        } else {
            ia = new AdaptorFixedInv((FixedItemInv)new WrapperCursorItemHandler(who.field_7514));
            maxTimesToCraft = 1;
        }
        maxTimesToCraft = this.capCraftingAttempts(maxTimesToCraft);
        if (ia == null) {
            return;
        }
        class_1799 rs = this.method_7677().method_7972();
        if (rs.method_7960()) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            IItemList<IAEItemStack> all;
            class_1799 extra;
            if (!ia.simulateAdd(rs).method_7960() || (extra = ia.addItems(this.craftItem(who, rs, inv, all = inv.getStorageList()))).method_7960()) continue;
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            drops.add(extra);
            Platform.spawnDrops(who.field_6002, new class_2338((int)who.method_23317(), (int)who.method_23318(), (int)who.method_23321()), drops);
            return;
        }
    }

    protected class_1860<class_1715> findRecipe(class_1715 ic, class_1937 world) {
        CraftingTermContainer containerTerminal;
        class_1860<class_1715> recipe;
        if (this.container instanceof CraftingTermContainer && (recipe = (containerTerminal = (CraftingTermContainer)this.container).getCurrentRecipe()) != null && recipe.method_8115((class_1263)ic, world)) {
            return containerTerminal.getCurrentRecipe();
        }
        return world.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, world).orElse(null);
    }

    @Override
    protected class_2371<class_1799> getRemainingItems(class_1715 ic, class_1937 world) {
        CraftingTermContainer containerTerminal;
        class_1860<class_1715> recipe;
        if (this.container instanceof CraftingTermContainer && (recipe = (containerTerminal = (CraftingTermContainer)this.container).getCurrentRecipe()) != null && recipe.method_8115((class_1263)ic, world)) {
            return recipe.method_8111((class_1263)ic);
        }
        return super.getRemainingItems(ic, world);
    }

    private int capCraftingAttempts(int maxTimesToCraft) {
        return maxTimesToCraft;
    }

    private class_1799 craftItem(class_1657 p, class_1799 request, IMEMonitor<IAEItemStack> inv, IItemList all) {
        class_1799 is = this.method_7677();
        if (!is.method_7960() && class_1799.method_7987((class_1799)request, (class_1799)is)) {
            Object[] set = new class_1799[this.getPattern().getSlotCount()];
            Arrays.fill(set, class_1799.field_8037);
            if (Platform.isServer()) {
                class_1715 ic = new class_1715((class_1703)new ContainerNull(), 3, 3);
                for (int x = 0; x < 9; ++x) {
                    ic.method_5447(x, this.getPattern().getInvStack(x));
                }
                class_1860<class_1715> r = this.findRecipe(ic, p.field_6002);
                if (r == null) {
                    class_1792 target = request.method_7909();
                    if (target.method_7846()) {
                        boolean isBad = false;
                        for (int x = 0; x < ic.method_5439(); ++x) {
                            class_1799 pis = ic.method_5438(x);
                            if (pis.method_7960() || pis.method_7909() == target) continue;
                            isBad = true;
                        }
                        if (!isBad) {
                            super.method_7667(p, is);
                            p.field_7512.method_7609((class_1263)new WrapperInvItemHandler(this.craftInv));
                            return request;
                        }
                    }
                    return class_1799.field_8037;
                }
                is = r.method_8116((class_1263)ic);
                if (inv != null) {
                    for (int x = 0; x < this.getPattern().getSlotCount(); ++x) {
                        if (this.getPattern().getInvStack(x).method_7960()) continue;
                        set[x] = Platform.extractItemsByRecipe(this.energySrc, this.mySrc, inv, p.field_6002, r, is, ic, this.getPattern().getInvStack(x), x, all, Actionable.MODULATE, ViewCellItem.createFilter(this.container.getViewCells()));
                        ic.method_5447(x, (class_1799)set[x]);
                    }
                }
            }
            if (this.preCraft(p, inv, (class_1799[])set, is)) {
                this.makeItem(p, is);
                this.postCraft(p, inv, (class_1799[])set, is);
            }
            p.field_7512.method_7609((class_1263)new WrapperInvItemHandler(this.craftInv));
            return is;
        }
        return class_1799.field_8037;
    }

    private boolean preCraft(class_1657 p, IMEMonitor<IAEItemStack> inv, class_1799[] set, class_1799 result) {
        return true;
    }

    private void makeItem(class_1657 p, class_1799 is) {
        super.method_7667(p, is);
    }

    private void postCraft(class_1657 p, IMEMonitor<IAEItemStack> inv, class_1799[] set, class_1799 result) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        if (Platform.isServer()) {
            for (int x = 0; x < this.craftInv.getSlotCount(); ++x) {
                IAEItemStack fail;
                if (this.craftInv.getInvStack(x).method_7960()) {
                    ItemHandlerUtil.setStackInSlot(this.craftInv, x, set[x]);
                    continue;
                }
                if (set[x].method_7960() || (fail = inv.injectItems(AEItemStack.fromItemStack(set[x]), Actionable.MODULATE, this.mySrc)) == null) continue;
                drops.add(fail.createItemStack());
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops(p.field_6002, new class_2338((int)p.method_23317(), (int)p.method_23318(), (int)p.method_23321()), drops);
        }
    }

    FixedItemInv getPattern() {
        return this.pattern;
    }
}

