/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.features.INetworkEncodable;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.container.slot.AppEngSlot;
import appeng.core.Api;
import appeng.items.misc.EncodedPatternItem;
import appeng.recipes.handlers.GrinderRecipes;
import appeng.tile.misc.InscriberRecipes;
import appeng.util.Platform;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;

public class RestrictedInputSlot
extends AppEngSlot {
    private static final List<class_2960> METAL_INGOT_TAGS = ImmutableList.of((Object)new class_2960("c:copper_ingots"), (Object)new class_2960("c:tin_ingots"), (Object)new class_2960("c:iron_ingots"), (Object)new class_2960("c:gold_ingots"), (Object)new class_2960("c:lead_ingots"), (Object)new class_2960("c:bronze_ingots"), (Object)new class_2960("c:brass_ingots"), (Object)new class_2960("c:nickel_ingots"), (Object)new class_2960("c:aluminium_ingots"));
    private final PlacableItemType which;
    private final class_1661 p;
    private boolean allowEdit = true;
    private int stackLimit = -1;

    public RestrictedInputSlot(PlacableItemType valid, FixedItemInv inv, int invSlot, int x, int y, class_1661 p) {
        super(inv, invSlot, x, y);
        this.which = valid;
        this.setIIcon(valid.IIcon);
        this.p = p;
    }

    @Override
    public int method_7675() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.method_7675();
    }

    public boolean isValid(class_1799 is, class_1937 theWorld) {
        if (this.which == PlacableItemType.VALID_ENCODED_PATTERN_W_OUTPUT) {
            return Api.instance().crafting().decodePattern(is, theWorld) != null;
        }
        return true;
    }

    public class_1735 setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    @Override
    public boolean method_7680(class_1799 stack) {
        if (!this.getContainer().isValidForSlot(this, stack)) {
            return false;
        }
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_8162) {
            return false;
        }
        if (!super.method_7680(stack)) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        IDefinitions definitions = Api.instance().definitions();
        IMaterials materials = definitions.materials();
        IItems items = definitions.items();
        ICraftingHelper crafting = Api.instance().crafting();
        switch (this.which) {
            case ENCODED_CRAFTING_PATTERN: {
                ICraftingPatternDetails de = crafting.decodePattern(stack, this.p.field_7546.field_6002);
                if (de != null) {
                    return de.isCraftable();
                }
                return false;
            }
            case VALID_ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN: {
                return crafting.isEncodedPattern(stack);
            }
            case BLANK_PATTERN: {
                return materials.blankPattern().isSameAs(stack);
            }
            case PATTERN: {
                return materials.blankPattern().isSameAs(stack) || crafting.isEncodedPattern(stack);
            }
            case INSCRIBER_PLATE: {
                if (materials.namePress().isSameAs(stack)) {
                    return true;
                }
                return InscriberRecipes.isValidOptionalIngredient(this.p.field_7546.field_6002, stack);
            }
            case INSCRIBER_INPUT: {
                return true;
            }
            case METAL_INGOTS: {
                return RestrictedInputSlot.isMetalIngot(stack);
            }
            case VIEW_CELL: {
                return items.viewCell().isSameAs(stack);
            }
            case ORE: {
                return GrinderRecipes.isValidIngredient(this.p.field_7546.field_6002, stack);
            }
            case FUEL: {
                return FuelRegistry.INSTANCE.get((class_1935)stack.method_7909()) != null;
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(stack);
            }
            case QE_SINGULARITY: {
                return materials.qESingularity().isSameAs(stack);
            }
            case RANGE_BOOSTER: {
                return materials.wirelessBooster().isSameAs(stack);
            }
            case SPATIAL_STORAGE_CELLS: {
                return stack.method_7909() instanceof ISpatialStorageCell && ((ISpatialStorageCell)stack.method_7909()).isSpatialStorage(stack);
            }
            case STORAGE_CELLS: {
                return Api.instance().registries().cell().isCellHandled(stack);
            }
            case WORKBENCH_CELL: {
                return stack.method_7909() instanceof ICellWorkbenchItem && ((ICellWorkbenchItem)stack.method_7909()).isEditable(stack);
            }
            case STORAGE_COMPONENT: {
                return stack.method_7909() instanceof IStorageComponent && ((IStorageComponent)stack.method_7909()).isStorageComponent(stack);
            }
            case TRASH: {
                if (Api.instance().registries().cell().isCellHandled(stack)) {
                    return false;
                }
                return !(stack.method_7909() instanceof IStorageComponent) || !((IStorageComponent)stack.method_7909()).isStorageComponent(stack);
            }
            case ENCODABLE_ITEM: {
                return stack.method_7909() instanceof INetworkEncodable || Api.instance().registries().wireless().isWirelessTerminal(stack);
            }
            case BIOMETRIC_CARD: {
                return stack.method_7909() instanceof IBiometricCard;
            }
            case UPGRADES: {
                return stack.method_7909() instanceof IUpgradeModule && ((IUpgradeModule)stack.method_7909()).getType(stack) != null;
            }
        }
        return false;
    }

    @Override
    public boolean method_7674(class_1657 player) {
        return this.isAllowEdit();
    }

    @Override
    public class_1799 getDisplayStack() {
        EncodedPatternItem iep;
        class_1799 out;
        class_1799 is;
        if (Platform.isClient() && this.which == PlacableItemType.ENCODED_PATTERN && !(is = super.method_7677()).method_7960() && is.method_7909() instanceof EncodedPatternItem && !(out = (iep = (EncodedPatternItem)is.method_7909()).getOutput(this.p.field_7546.field_6002, is)).method_7960()) {
            return out;
        }
        return super.method_7677();
    }

    public static boolean isMetalIngot(class_1799 i) {
        if (Platform.itemComparisons().isSameItem(i, new class_1799((class_1935)class_1802.field_8620))) {
            return true;
        }
        class_1792 item = i.method_7909();
        for (class_2960 tagName : METAL_INGOT_TAGS) {
            class_3494 ingotTag = class_3489.method_15106().method_30210(tagName);
            if (ingotTag == null || !item.method_7855(ingotTag)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public static enum PlacableItemType {
        STORAGE_CELLS(15),
        ORE(31),
        STORAGE_COMPONENT(63),
        ENCODABLE_ITEM(79),
        TRASH(95),
        VALID_ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_CRAFTING_PATTERN(127),
        ENCODED_PATTERN(127),
        PATTERN(143),
        BLANK_PATTERN(143),
        POWERED_TOOL(159),
        RANGE_BOOSTER(111),
        QE_SINGULARITY(175),
        SPATIAL_STORAGE_CELLS(191),
        FUEL(207),
        UPGRADES(223),
        WORKBENCH_CELL(15),
        BIOMETRIC_CARD(239),
        VIEW_CELL(78),
        INSCRIBER_PLATE(46),
        INSCRIBER_INPUT(62),
        METAL_INGOTS(62);

        public final int IIcon;

        private PlacableItemType(int o) {
            this.IIcon = o;
        }
    }
}

