/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.CondenserOutput;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.features.AEFeature;
import appeng.client.gui.NumberEntryType;
import appeng.core.AELog;
import appeng.core.config.BooleanOption;
import appeng.core.config.ConfigFileManager;
import appeng.core.config.ConfigSection;
import appeng.core.config.DoubleOption;
import appeng.core.config.EnumOption;
import appeng.core.config.IntegerOption;
import appeng.core.config.StringListOption;
import appeng.core.config.StringOption;
import appeng.core.settings.TickRates;
import appeng.util.EnumCycler;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class AEConfig {
    public final ClientConfig clientConfig;
    public final ConfigFileManager clientConfigManager;
    public final CommonConfig commonConfig;
    public final ConfigFileManager commonConfigManager;
    private static final double DEFAULT_IC2_EXCHANGE = 2.0;
    private static final double DEFAULT_TR_EXCHANGE = 2.0;
    public static final String VERSION = "@version@";
    public static final String CHANNEL = "@aechannel@";
    private static AEConfig instance;
    private final EnumSet<AEFeature> featureFlags = EnumSet.noneOf(AEFeature.class);
    private boolean removeCrashingItemsOnLoad;
    private int formationPlaneEntityLimit;
    private boolean enableEffects;
    private boolean useLargeFonts;
    private boolean useColoredCraftingStatus;
    private boolean disableColoredCableRecipesInJEI;
    private int craftingCalculationTimePerTick;
    private final int[] craftByStacks = new int[4];
    private final int[] priorityByStacks = new int[4];
    private final int[] levelByStacks = new int[4];
    private final int[] levelByMillibuckets = new int[]{10, 100, 1000, 10000};
    private double spatialPowerExponent;
    private double spatialPowerMultiplier;
    private boolean spatialBlockTags;
    private float oreDoublePercentage;
    private int wirelessTerminalBattery;
    private int entropyManipulatorBattery;
    private int matterCannonBattery;
    private int portableCellBattery;
    private int colorApplicatorBattery;
    private int chargedStaffBattery;
    private double wirelessBaseCost;
    private double wirelessCostMultiplier;
    private double wirelessTerminalDrainMultiplier;
    private double wirelessBaseRange;
    private double wirelessBoosterRangeMultiplier;
    private double wirelessBoosterExp;
    private double wirelessHighWirelessCount;
    public static final double TUNNEL_POWER_LOSS = 0.05;

    AEConfig(File configDir) {
        ConfigSection clientRoot = ConfigSection.createRoot();
        this.clientConfig = new ClientConfig(clientRoot);
        this.clientConfigManager = AEConfig.createConfigFileManager(clientRoot, configDir, "appliedenergistics2/client.json");
        ConfigSection commonRoot = ConfigSection.createRoot();
        this.commonConfig = new CommonConfig(commonRoot);
        this.commonConfigManager = AEConfig.createConfigFileManager(commonRoot, configDir, "appliedenergistics2/common.json");
        this.syncClientConfig();
        this.syncCommonConfig();
    }

    private static ConfigFileManager createConfigFileManager(ConfigSection commonRoot, File configDir, String filename) {
        File configFile = new File(configDir, filename);
        ConfigFileManager result = new ConfigFileManager(commonRoot, configFile);
        if (!configFile.exists()) {
            result.save();
        } else {
            result.load();
            try {
                result.save();
            }
            catch (Exception e) {
                AELog.warn(e);
            }
        }
        return result;
    }

    public static void load(File configFolder) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = new AEConfig(configFolder);
    }

    private void syncClientConfig() {
        this.disableColoredCableRecipesInJEI = this.clientConfig.disableColoredCableRecipesInJEI.get();
        this.enableEffects = this.clientConfig.enableEffects.get();
        this.useLargeFonts = this.clientConfig.useLargeFonts.get();
        this.useColoredCraftingStatus = this.clientConfig.useColoredCraftingStatus.get();
        for (int btnNum = 0; btnNum < 4; ++btnNum) {
            this.craftByStacks[btnNum] = this.clientConfig.craftByStacks.get(btnNum).get();
            this.priorityByStacks[btnNum] = this.clientConfig.priorityByStacks.get(btnNum).get();
            this.levelByStacks[btnNum] = this.clientConfig.levelByStacks.get(btnNum).get();
        }
    }

    private void syncCommonConfig() {
        PowerUnits.EU.conversionRatio = this.commonConfig.powerRatioIc2.get();
        PowerUnits.TR.conversionRatio = this.commonConfig.powerRatioTechReborn.get();
        PowerMultiplier.CONFIG.multiplier = this.commonConfig.powerUsageMultiplier.get();
        CondenserOutput.MATTER_BALLS.requiredPower = this.commonConfig.condenserMatterBallsPower.get();
        CondenserOutput.SINGULARITY.requiredPower = this.commonConfig.condenserSingularityPower.get();
        this.oreDoublePercentage = (float)this.commonConfig.oreDoublePercentage.get();
        this.wirelessBaseCost = this.commonConfig.wirelessBaseCost.get();
        this.wirelessCostMultiplier = this.commonConfig.wirelessCostMultiplier.get();
        this.wirelessBaseRange = this.commonConfig.wirelessBaseRange.get();
        this.wirelessBoosterRangeMultiplier = this.commonConfig.wirelessBoosterRangeMultiplier.get();
        this.wirelessBoosterExp = this.commonConfig.wirelessBoosterExp.get();
        this.wirelessHighWirelessCount = this.commonConfig.wirelessHighWirelessCount.get();
        this.wirelessTerminalDrainMultiplier = this.commonConfig.wirelessTerminalDrainMultiplier.get();
        this.formationPlaneEntityLimit = this.commonConfig.formationPlaneEntityLimit.get();
        this.wirelessTerminalBattery = this.commonConfig.wirelessTerminalBattery.get();
        this.chargedStaffBattery = this.commonConfig.chargedStaffBattery.get();
        this.entropyManipulatorBattery = this.commonConfig.entropyManipulatorBattery.get();
        this.portableCellBattery = this.commonConfig.portableCellBattery.get();
        this.colorApplicatorBattery = this.commonConfig.colorApplicatorBattery.get();
        this.matterCannonBattery = this.commonConfig.matterCannonBattery.get();
        this.featureFlags.clear();
        for (AEFeature aEFeature : AEFeature.values()) {
            if (aEFeature.isVisible() && aEFeature.isConfig()) {
                if (!this.commonConfig.enabledFeatures.containsKey((Object)aEFeature) || !this.commonConfig.enabledFeatures.get((Object)aEFeature).get()) continue;
                this.featureFlags.add(aEFeature);
                continue;
            }
            this.featureFlags.add(aEFeature);
        }
        for (Enum enum_ : TickRates.values()) {
            ((TickRates)enum_).setMin(this.commonConfig.tickRateMin.get(enum_).get());
            ((TickRates)enum_).setMax(this.commonConfig.tickRateMin.get(enum_).get());
        }
        this.spatialPowerMultiplier = this.commonConfig.spatialPowerMultiplier.get();
        this.spatialPowerExponent = this.commonConfig.spatialPowerExponent.get();
        this.spatialBlockTags = this.commonConfig.spatialBlockTags.get();
        this.craftingCalculationTimePerTick = this.commonConfig.craftingCalculationTimePerTick.get();
        this.removeCrashingItemsOnLoad = this.commonConfig.removeCrashingItemsOnLoad.get();
    }

    public static AEConfig instance() {
        return instance;
    }

    public boolean isFeatureEnabled(AEFeature f) {
        return !f.isConfig() && f.isEnabled() || this.featureFlags.contains((Object)f);
    }

    public boolean areFeaturesEnabled(Collection<AEFeature> features) {
        return this.featureFlags.containsAll(features);
    }

    public double wireless_getDrainRate(double range) {
        return this.wirelessTerminalDrainMultiplier * range;
    }

    public double wireless_getMaxRange(int boosters) {
        return this.wirelessBaseRange + this.wirelessBoosterRangeMultiplier * Math.pow(boosters, this.wirelessBoosterExp);
    }

    public double wireless_getPowerDrain(int boosters) {
        return this.wirelessBaseCost + this.wirelessCostMultiplier * Math.pow(boosters, 1.0 + (double)boosters / this.wirelessHighWirelessCount);
    }

    public YesNo getSearchTooltips() {
        return this.clientConfig.searchTooltips.get();
    }

    public TerminalStyle getTerminalStyle() {
        return this.clientConfig.terminalStyle.get();
    }

    public void setTerminalStyle(TerminalStyle setting) {
        this.clientConfig.terminalStyle.set(setting);
    }

    public SearchBoxMode getTerminalSearchMode() {
        return this.clientConfig.terminalSearchMode.get();
    }

    public void setTerminalSearchMode(SearchBoxMode setting) {
        this.clientConfig.terminalSearchMode.set(setting);
    }

    public void save() {
    }

    public int[] getNumberEntrySteps(NumberEntryType type) {
        switch (type) {
            case CRAFT_ITEM_COUNT: {
                return this.craftByStacks;
            }
            case PRIORITY: {
                return this.priorityByStacks;
            }
            case LEVEL_ITEM_COUNT: {
                return this.levelByStacks;
            }
            case LEVEL_FLUID_VOLUME: {
                return this.levelByMillibuckets;
            }
        }
        throw new IllegalArgumentException("Unknown number entry: " + (Object)((Object)type));
    }

    public PowerUnits getSelectedPowerUnit() {
        return this.clientConfig.selectedPowerUnit.get();
    }

    public void nextPowerUnit(boolean backwards) {
        PowerUnits selectedPowerUnit = (PowerUnits)EnumCycler.rotateEnum(this.getSelectedPowerUnit(), backwards, Settings.POWER_UNITS.getPossibleValues());
        this.clientConfig.selectedPowerUnit.set(selectedPowerUnit);
    }

    public boolean isRemoveCrashingItemsOnLoad() {
        return this.removeCrashingItemsOnLoad;
    }

    public int getFormationPlaneEntityLimit() {
        return this.formationPlaneEntityLimit;
    }

    public boolean isEnableEffects() {
        return this.enableEffects;
    }

    public boolean isUseLargeFonts() {
        return this.useLargeFonts;
    }

    public boolean isUseColoredCraftingStatus() {
        return this.useColoredCraftingStatus;
    }

    public boolean isDisableColoredCableRecipesInJEI() {
        return this.disableColoredCableRecipesInJEI;
    }

    public int getCraftingCalculationTimePerTick() {
        return this.craftingCalculationTimePerTick;
    }

    public double getSpatialPowerExponent() {
        return this.spatialPowerExponent;
    }

    public double getSpatialPowerMultiplier() {
        return this.spatialPowerMultiplier;
    }

    public boolean getSpatialBlockTags() {
        return this.spatialBlockTags;
    }

    public float getOreDoublePercentage() {
        return this.oreDoublePercentage;
    }

    public DoubleSupplier getWirelessTerminalBattery() {
        return () -> this.wirelessTerminalBattery;
    }

    public DoubleSupplier getEntropyManipulatorBattery() {
        return () -> this.entropyManipulatorBattery;
    }

    public DoubleSupplier getMatterCannonBattery() {
        return () -> this.matterCannonBattery;
    }

    public DoubleSupplier getPortableCellBattery() {
        return () -> this.portableCellBattery;
    }

    public DoubleSupplier getColorApplicatorBattery() {
        return () -> this.colorApplicatorBattery;
    }

    public DoubleSupplier getChargedStaffBattery() {
        return () -> this.chargedStaffBattery;
    }

    public double getPowerTransactionLimitTechReborn() {
        return this.commonConfig.powerTransactionLimitTechReborn.get();
    }

    public float getSpawnChargedChance() {
        return (float)this.commonConfig.spawnChargedChance.get();
    }

    public int getQuartzOresPerCluster() {
        return this.commonConfig.quartzOresPerCluster.get();
    }

    public int getQuartzOresClusterAmount() {
        return this.commonConfig.quartzOresClusterAmount.get();
    }

    public List<String> getMeteoriteBiomeBlacklist() {
        return this.commonConfig.meteoriteBiomeBlacklist.get();
    }

    public List<String> getQuartzOreBiomeBlacklist() {
        return this.commonConfig.quartzOreBiomeBlacklist.get();
    }

    @Nullable
    public String getImprovedFluidTag() {
        return Strings.emptyToNull((String)this.commonConfig.improvedFluidTag.get());
    }

    public float getImprovedFluidMultiplier() {
        return (float)this.commonConfig.improvedFluidMultiplier.get();
    }

    private static class CommonConfig {
        public final Map<AEFeature, BooleanOption> enabledFeatures = new EnumMap<AEFeature, BooleanOption>(AEFeature.class);
        public final BooleanOption removeCrashingItemsOnLoad;
        public final IntegerOption formationPlaneEntityLimit;
        public final IntegerOption craftingCalculationTimePerTick;
        public final DoubleOption spatialPowerExponent;
        public final DoubleOption spatialPowerMultiplier;
        public final BooleanOption spatialBlockTags;
        public final DoubleOption oreDoublePercentage;
        public final IntegerOption wirelessTerminalBattery;
        public final IntegerOption entropyManipulatorBattery;
        public final IntegerOption matterCannonBattery;
        public final IntegerOption portableCellBattery;
        public final IntegerOption colorApplicatorBattery;
        public final IntegerOption chargedStaffBattery;
        public final DoubleOption spawnChargedChance;
        public final IntegerOption quartzOresPerCluster;
        public final IntegerOption quartzOresClusterAmount;
        public final StringListOption quartzOreBiomeBlacklist;
        public final StringListOption meteoriteBiomeBlacklist;
        public final DoubleOption wirelessBaseCost;
        public final DoubleOption wirelessCostMultiplier;
        public final DoubleOption wirelessTerminalDrainMultiplier;
        public final DoubleOption wirelessBaseRange;
        public final DoubleOption wirelessBoosterRangeMultiplier;
        public final DoubleOption wirelessBoosterExp;
        public final DoubleOption wirelessHighWirelessCount;
        public final DoubleOption powerRatioIc2;
        public final DoubleOption powerRatioTechReborn;
        public final DoubleOption powerUsageMultiplier;
        public final DoubleOption powerTransactionLimitTechReborn;
        public final IntegerOption condenserMatterBallsPower;
        public final IntegerOption condenserSingularityPower;
        public final StringOption improvedFluidTag;
        public final DoubleOption improvedFluidMultiplier;
        public final Map<TickRates, IntegerOption> tickRateMin = new HashMap<TickRates, IntegerOption>();
        public final Map<TickRates, IntegerOption> tickRateMax = new HashMap<TickRates, IntegerOption>();

        public CommonConfig(ConfigSection root) {
            ConfigSection features = root.subsection("features", "Warning: Disabling a feature may disable other features depending on it.");
            Map<String, List<AEFeature>> groupedFeatures = Arrays.stream(AEFeature.values()).filter(AEFeature::isVisible).collect(Collectors.groupingBy(AEFeature::category));
            for (String category : groupedFeatures.keySet()) {
                List<AEFeature> featuresInGroup = groupedFeatures.get(category);
                ConfigSection categorySection = features.subsection(category);
                for (AEFeature feature : featuresInGroup) {
                    if (!feature.isConfig()) continue;
                    this.enabledFeatures.put(feature, categorySection.addBoolean(feature.key(), feature.isEnabled(), feature.comment()));
                }
            }
            ConfigSection general = root.subsection("general");
            this.removeCrashingItemsOnLoad = general.addBoolean("removeCrashingItemsOnLoad", false, "Will auto-remove items that crash when being loaded from storage. This will destroy those items instead of crashing the game!");
            ConfigSection automation = root.subsection("automation");
            this.formationPlaneEntityLimit = automation.addInt("formationPlaneEntityLimit", 128);
            ConfigSection craftingCPU = root.subsection("craftingCPU");
            this.craftingCalculationTimePerTick = craftingCPU.addInt("craftingCalculationTimePerTick", 5);
            ConfigSection spatialio = root.subsection("spatialio");
            this.spatialPowerMultiplier = spatialio.addDouble("spatialPowerMultiplier", 1250.0);
            this.spatialPowerExponent = spatialio.addDouble("spatialPowerExponent", 1.35);
            this.spatialBlockTags = spatialio.addBoolean("spatialBlockTags", false, "BE CAREFUL, CAN CORRUPT YOUR WORLD! Will use #spatial/whitelist as whitelist.");
            ConfigSection grindStone = root.subsection("GrindStone");
            this.oreDoublePercentage = grindStone.addDouble("oreDoublePercentage", 90.0, 0.0, 100.0, "Chance to actually get an output with stacksize > 1.");
            ConfigSection battery = root.subsection("battery");
            this.wirelessTerminalBattery = battery.addInt("wirelessTerminal", 1600000);
            this.chargedStaffBattery = battery.addInt("chargedStaff", 8000);
            this.entropyManipulatorBattery = battery.addInt("entropyManipulator", 200000);
            this.portableCellBattery = battery.addInt("portableCell", 20000);
            this.colorApplicatorBattery = battery.addInt("colorApplicator", 20000);
            this.matterCannonBattery = battery.addInt("matterCannon", 200000);
            ConfigSection worldGen = root.subsection("worldGen");
            this.spawnChargedChance = worldGen.addDouble("spawnChargedChance", 0.08, 0.0, 1.0);
            this.meteoriteBiomeBlacklist = worldGen.addStringList("meteoriteBiomeBlacklist", new ArrayList<String>(), "Biome IDs in which meteorites should NOT be generated (i.e. minecraft:plains).");
            this.quartzOresPerCluster = worldGen.addInt("quartzOresPerCluster", 4);
            this.quartzOresClusterAmount = worldGen.addInt("quartzOresClusterAmount", 20);
            this.quartzOreBiomeBlacklist = worldGen.addStringList("quartzOreBiomeBlacklist", new ArrayList<String>(), "Biome IDs in which quartz ores should NOT be generated (i.e. minecraft:plains).");
            ConfigSection wireless = root.subsection("wireless");
            this.wirelessBaseCost = wireless.addDouble("wirelessBaseCost", 8.0);
            this.wirelessCostMultiplier = wireless.addDouble("wirelessCostMultiplier", 1.0);
            this.wirelessBaseRange = wireless.addDouble("wirelessBaseRange", 16.0);
            this.wirelessBoosterRangeMultiplier = wireless.addDouble("wirelessBoosterRangeMultiplier", 1.0);
            this.wirelessBoosterExp = wireless.addDouble("wirelessBoosterExp", 1.5);
            this.wirelessHighWirelessCount = wireless.addDouble("wirelessHighWirelessCount", 64.0);
            this.wirelessTerminalDrainMultiplier = wireless.addDouble("wirelessTerminalDrainMultiplier", 1.0);
            ConfigSection PowerRatios = root.subsection("PowerRatios");
            this.powerRatioIc2 = PowerRatios.addDouble("IC2", 2.0);
            this.powerRatioTechReborn = PowerRatios.addDouble("TechReborn", 2.0);
            this.powerUsageMultiplier = PowerRatios.addDouble("UsageMultiplier", 1.0, 0.01, Double.MAX_VALUE);
            ConfigSection integration = root.subsection("Integration");
            this.powerTransactionLimitTechReborn = integration.addDouble("MaxTechRebornEnergyPerTransaction", 10000.0, 0.1, 1000000.0, "The maximum amount of TechReborn energy units that can be transfered per operation.");
            ConfigSection Condenser = root.subsection("Condenser");
            this.condenserMatterBallsPower = Condenser.addInt("MatterBalls", 256);
            this.condenserSingularityPower = Condenser.addInt("Singularity", 256000);
            ConfigSection tickrates = root.subsection("tickRates", " Min / Max Tickrates for dynamic ticking, most of these components also use sleeping, to prevent constant ticking, adjust with care, non standard rates are not supported or tested.");
            for (TickRates tickRate : TickRates.values()) {
                this.tickRateMin.put(tickRate, tickrates.addInt(tickRate.name() + "Min", tickRate.getDefaultMin()));
                this.tickRateMax.put(tickRate, tickrates.addInt(tickRate.name() + "Max", tickRate.getDefaultMax()));
            }
            ConfigSection inWorldPurification = root.subsection("inWorldPurification", "Settings for in-world purification of crystals.");
            this.improvedFluidTag = inWorldPurification.addString("improvedFluidTag", "", "A fluid tag that identifies fluids that improve crystal purification speed. Does not affect purification with water/lava.");
            this.improvedFluidMultiplier = inWorldPurification.addDouble("improvedFluidMultiplier", 2.0, 1.0, 10.0, "The speed multiplier to use when the crystals are submerged in the improved fluid.");
        }
    }

    private static class ClientConfig {
        public final BooleanOption enableEffects;
        public final BooleanOption useLargeFonts;
        public final BooleanOption useColoredCraftingStatus;
        public final BooleanOption disableColoredCableRecipesInJEI;
        public final EnumOption<PowerUnits> selectedPowerUnit;
        private static final int[] BTN_BY_STACK_DEFAULTS = new int[]{1, 10, 100, 1000};
        public final List<IntegerOption> craftByStacks;
        public final List<IntegerOption> priorityByStacks;
        public final List<IntegerOption> levelByStacks;
        public final EnumOption<YesNo> searchTooltips;
        public final EnumOption<TerminalStyle> terminalStyle;
        public final EnumOption<SearchBoxMode> terminalSearchMode;

        public ClientConfig(ConfigSection root) {
            ConfigSection client = root.subsection("client");
            this.disableColoredCableRecipesInJEI = client.addBoolean("disableColoredCableRecipesInJEI", true);
            this.enableEffects = client.addBoolean("enableEffects", true);
            this.useLargeFonts = client.addBoolean("useTerminalUseLargeFont", false);
            this.useColoredCraftingStatus = client.addBoolean("useColoredCraftingStatus", true);
            this.selectedPowerUnit = client.addEnum("PowerUnit", PowerUnits.AE, "Power unit shown in AE UIs");
            this.craftByStacks = new ArrayList<IntegerOption>(4);
            this.priorityByStacks = new ArrayList<IntegerOption>(4);
            this.levelByStacks = new ArrayList<IntegerOption>(4);
            for (int btnNum = 0; btnNum < 4; ++btnNum) {
                int defaultValue = BTN_BY_STACK_DEFAULTS[btnNum];
                int buttonCap = (int)(Math.pow(10.0, btnNum + 1) - 1.0);
                this.craftByStacks.add(client.addInt("craftByStacks" + btnNum, defaultValue, 1, buttonCap, "Controls buttons on Crafting Screen"));
                this.priorityByStacks.add(client.addInt("priorityByStacks" + btnNum, defaultValue, 1, buttonCap, "Controls buttons on Priority Screen"));
                this.levelByStacks.add(client.addInt("levelByStacks" + btnNum, defaultValue, 1, buttonCap, "Controls buttons on Level Emitter Screen"));
            }
            ConfigSection terminals = root.subsection("terminals");
            this.searchTooltips = terminals.addEnum("searchTooltips", YesNo.YES, "Should tooltips be searched. Performance impact");
            this.terminalStyle = terminals.addEnum("terminalStyle", TerminalStyle.TALL);
            this.terminalSearchMode = terminals.addEnum("terminalSearchMode", SearchBoxMode.AUTOSEARCH);
        }
    }
}

