/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.tile.AEBaseBlockEntity;
import appeng.util.Platform;
import javax.annotation.Nonnull;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AELog {
    private static final String LOGGER_PREFIX = "AE2:";
    private static final String SERVER_SUFFIX = "S";
    private static final String CLIENT_SUFFIX = "C";
    private static final Logger SERVER = LogManager.getFormatterLogger((String)"AE2:S");
    private static final Logger CLIENT = LogManager.getFormatterLogger((String)"AE2:C");
    private static final String BLOCK_UPDATE = "Block Update of %s @ ( %s ). State %s -> %s";
    private static final String DEFAULT_EXCEPTION_MESSAGE = "Exception: ";

    private AELog() {
    }

    private static Logger getLogger() {
        return Platform.isServer() ? SERVER : CLIENT;
    }

    public static boolean isLogEnabled() {
        return AEConfig.instance() == null || AEConfig.instance().isFeatureEnabled(AEFeature.LOGGING);
    }

    public static void log(@Nonnull Level level, @Nonnull String message, Object ... params) {
        if (AELog.isLogEnabled()) {
            String formattedMessage = String.format(message, params);
            Logger logger = AELog.getLogger();
            logger.log(level, formattedMessage);
        }
    }

    public static void log(@Nonnull Level level, @Nonnull Throwable exception, @Nonnull String message, Object ... params) {
        if (AELog.isLogEnabled()) {
            String formattedMessage = String.format(message, params);
            Logger logger = AELog.getLogger();
            logger.log(level, formattedMessage, exception);
        }
    }

    public static void info(@Nonnull String format, Object ... params) {
        AELog.log(Level.INFO, format, params);
    }

    public static void info(@Nonnull Throwable exception) {
        AELog.log(Level.INFO, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
    }

    public static void info(@Nonnull Throwable exception, @Nonnull String message) {
        AELog.log(Level.INFO, exception, message, new Object[0]);
    }

    public static void warn(@Nonnull String format, Object ... params) {
        AELog.log(Level.WARN, format, params);
    }

    public static void warn(@Nonnull Throwable exception) {
        AELog.log(Level.WARN, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
    }

    public static void warn(@Nonnull Throwable exception, @Nonnull String message) {
        AELog.log(Level.WARN, exception, message, new Object[0]);
    }

    public static void error(@Nonnull String format, Object ... params) {
        AELog.log(Level.ERROR, format, params);
    }

    public static void error(@Nonnull Throwable exception) {
        AELog.log(Level.ERROR, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
    }

    public static void error(@Nonnull Throwable exception, @Nonnull String message) {
        AELog.log(Level.ERROR, exception, message, new Object[0]);
    }

    public static void debug(@Nonnull String format, Object ... data) {
        if (AELog.isDebugLogEnabled()) {
            AELog.log(Level.DEBUG, format, data);
        }
    }

    public static void debug(@Nonnull Throwable exception) {
        if (AELog.isDebugLogEnabled()) {
            AELog.log(Level.DEBUG, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
        }
    }

    public static void debug(@Nonnull Throwable exception, @Nonnull String message) {
        if (AELog.isDebugLogEnabled()) {
            AELog.log(Level.DEBUG, exception, message, new Object[0]);
        }
    }

    public static boolean isDebugLogEnabled() {
        return AEConfig.instance().isFeatureEnabled(AEFeature.DEBUG_LOGGING);
    }

    public static void grinder(@Nonnull String message, Object ... params) {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.GRINDER_LOGGING)) {
            AELog.log(Level.DEBUG, "grinder: " + message, params);
        }
    }

    public static void integration(@Nonnull Throwable exception) {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.INTEGRATION_LOGGING)) {
            AELog.debug(exception);
        }
    }

    public static void blockUpdate(@Nonnull class_2338 pos, @Nonnull class_2680 currentState, @Nonnull class_2680 newState, @Nonnull AEBaseBlockEntity aeBaseTile) {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.UPDATE_LOGGING)) {
            AELog.info(BLOCK_UPDATE, aeBaseTile.getClass().getName(), pos, currentState, newState);
        }
    }

    public static boolean isCraftingLogEnabled() {
        return AEConfig.instance().isFeatureEnabled(AEFeature.CRAFTING_LOG);
    }

    public static void crafting(@Nonnull String message, Object ... params) {
        if (AELog.isCraftingLogEnabled()) {
            AELog.log(Level.INFO, message, params);
        }
    }

    public static boolean isCraftingDebugLogEnabled() {
        return AEConfig.instance().isFeatureEnabled(AEFeature.CRAFTING_LOG) && AEConfig.instance().isFeatureEnabled(AEFeature.DEBUG_LOGGING);
    }

    public static void craftingDebug(@Nonnull String message, Object ... params) {
        if (AELog.isCraftingDebugLogEnabled()) {
            AELog.log(Level.DEBUG, message, params);
        }
    }
}

