/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.Upgrades;
import appeng.api.features.IRegistryContainer;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.networking.IGridCacheRegistry;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.parts.CableRenderMode;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.components.ITileEntityRegistrationComponent;
import appeng.client.render.effects.ParticleTypes;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpener;
import appeng.container.implementations.CellWorkbenchContainer;
import appeng.container.implementations.ChestContainer;
import appeng.container.implementations.CondenserContainer;
import appeng.container.implementations.CraftAmountContainer;
import appeng.container.implementations.CraftConfirmContainer;
import appeng.container.implementations.CraftingCPUContainer;
import appeng.container.implementations.CraftingStatusContainer;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.DriveContainer;
import appeng.container.implementations.FormationPlaneContainer;
import appeng.container.implementations.GrinderContainer;
import appeng.container.implementations.IOPortContainer;
import appeng.container.implementations.InscriberContainer;
import appeng.container.implementations.InterfaceContainer;
import appeng.container.implementations.InterfaceTerminalContainer;
import appeng.container.implementations.LevelEmitterContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.MEPortableCellContainer;
import appeng.container.implementations.MolecularAssemblerContainer;
import appeng.container.implementations.NetworkStatusContainer;
import appeng.container.implementations.NetworkToolContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.implementations.PriorityContainer;
import appeng.container.implementations.QNBContainer;
import appeng.container.implementations.QuartzKnifeContainer;
import appeng.container.implementations.SecurityStationContainer;
import appeng.container.implementations.SkyChestContainer;
import appeng.container.implementations.SpatialIOPortContainer;
import appeng.container.implementations.StorageBusContainer;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.implementations.VibrationChamberContainer;
import appeng.container.implementations.WirelessContainer;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.AppEng;
import appeng.core.api.definitions.ApiBlocks;
import appeng.core.api.definitions.ApiItems;
import appeng.core.api.definitions.ApiParts;
import appeng.core.features.registries.P2PTunnelRegistry;
import appeng.core.features.registries.cell.BasicCellHandler;
import appeng.core.features.registries.cell.BasicItemCellGuiHandler;
import appeng.core.features.registries.cell.CreativeCellHandler;
import appeng.core.localization.GuiText;
import appeng.core.stats.AdvancementTriggers;
import appeng.core.stats.AeStats;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.TargetPoint;
import appeng.fluids.container.FluidFormationPlaneContainer;
import appeng.fluids.container.FluidIOContainer;
import appeng.fluids.container.FluidInterfaceContainer;
import appeng.fluids.container.FluidLevelEmitterContainer;
import appeng.fluids.container.FluidStorageBusContainer;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.fluids.registries.BasicFluidCellGuiHandler;
import appeng.hooks.ToolItemHook;
import appeng.integration.modules.trenergy.ItemPowerStorageAdapter;
import appeng.items.parts.FacadeItem;
import appeng.items.tools.NetworkToolItem;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cache.EnergyGridCache;
import appeng.me.cache.GridStorageCache;
import appeng.me.cache.P2PCache;
import appeng.me.cache.PathGridCache;
import appeng.me.cache.SecurityCache;
import appeng.me.cache.SpatialPylonCache;
import appeng.me.cache.TickManagerCache;
import appeng.mixins.CriteriaRegisterMixin;
import appeng.recipes.game.DisassembleRecipe;
import appeng.recipes.game.FacadeRecipe;
import appeng.recipes.handlers.GrinderRecipe;
import appeng.recipes.handlers.GrinderRecipeSerializer;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.handlers.InscriberRecipeSerializer;
import appeng.recipes.handlers.QuartzKnifeRecipeSerializer;
import appeng.server.AECommand;
import appeng.tile.AEBaseBlockEntity;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2573;
import net.minecraft.class_2580;
import net.minecraft.class_2589;
import net.minecraft.class_2593;
import net.minecraft.class_2595;
import net.minecraft.class_2599;
import net.minecraft.class_2601;
import net.minecraft.class_2603;
import net.minecraft.class_2605;
import net.minecraft.class_2608;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2625;
import net.minecraft.class_2627;
import net.minecraft.class_2631;
import net.minecraft.class_2636;
import net.minecraft.class_2640;
import net.minecraft.class_2669;
import net.minecraft.class_2960;
import net.minecraft.class_3866;
import net.minecraft.class_3917;

public abstract class AppEngBase
implements AppEng {
    protected AdvancementTriggers advancementTriggers;
    private final ThreadLocal<class_1657> partInteractionPlayer = new ThreadLocal();

    public AppEngBase() {
        if (AppEng.instance() != null) {
            throw new IllegalStateException();
        }
        AeStats.register();
        this.advancementTriggers = new AdvancementTriggers(CriteriaRegisterMixin::callRegister);
        ToolItemHook.install();
        this.registerBlockEntities();
        this.registerScreenHandlerTypes();
        this.registerParticleTypes();
        this.registerRecipeSerializers();
        this.registerServerCommands();
        AppEngBase.setupInternalRegistries();
        ItemPowerStorageAdapter.register();
    }

    public static void setupInternalRegistries() {
        Api api = Api.INSTANCE;
        IRegistryContainer registries = api.registries();
        IGridCacheRegistry gcr = registries.gridCache();
        gcr.registerGridCache(ITickManager.class, TickManagerCache::new);
        gcr.registerGridCache(IEnergyGrid.class, EnergyGridCache::new);
        gcr.registerGridCache(IPathingGrid.class, PathGridCache::new);
        gcr.registerGridCache(IStorageGrid.class, GridStorageCache::new);
        gcr.registerGridCache(P2PCache.class, P2PCache::new);
        gcr.registerGridCache(ISpatialCache.class, SpatialPylonCache::new);
        gcr.registerGridCache(ISecurityGrid.class, SecurityCache::new);
        gcr.registerGridCache(ICraftingGrid.class, CraftingGridCache::new);
        registries.cell().addCellHandler(new BasicCellHandler());
        registries.cell().addCellHandler(new CreativeCellHandler());
        registries.cell().addCellGuiHandler(new BasicItemCellGuiHandler());
        registries.cell().addCellGuiHandler(new BasicFluidCellGuiHandler());
        registries.matterCannon().registerAmmoItem(api.definitions().materials().matterBall().item(), 32.0);
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        ApiParts parts = definitions.parts();
        ApiBlocks blocks = definitions.blocks();
        ApiItems items = definitions.items();
        String interfaceGroup = parts.iface().method_8389().method_7876();
        String itemIoBusGroup = GuiText.IOBuses.getTranslationKey();
        String fluidIoBusGroup = GuiText.IOBusesFluids.getTranslationKey();
        String storageCellGroup = GuiText.IOBusesFluids.getTranslationKey();
        ((P2PTunnelRegistry)registries.p2pTunnel()).configure();
        Upgrades.CRAFTING.registerItem(parts.iface(), 1, interfaceGroup);
        Upgrades.CRAFTING.registerItem(blocks.iface(), 1, interfaceGroup);
        Upgrades.SPEED.registerItem(blocks.iOPort(), 3);
        Upgrades.REDSTONE.registerItem(blocks.iOPort(), 1);
        Upgrades.FUZZY.registerItem(parts.levelEmitter(), 1);
        Upgrades.CRAFTING.registerItem(parts.levelEmitter(), 1);
        Upgrades.FUZZY.registerItem(parts.importBus(), 1, itemIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.importBus(), 1, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.importBus(), 2, itemIoBusGroup);
        Upgrades.SPEED.registerItem(parts.importBus(), 4, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.fluidImportBus(), 2, fluidIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.fluidImportBus(), 1, fluidIoBusGroup);
        Upgrades.SPEED.registerItem(parts.fluidImportBus(), 4, fluidIoBusGroup);
        Upgrades.FUZZY.registerItem(parts.exportBus(), 1, itemIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.exportBus(), 1, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.exportBus(), 2, itemIoBusGroup);
        Upgrades.SPEED.registerItem(parts.exportBus(), 4, itemIoBusGroup);
        Upgrades.CRAFTING.registerItem(parts.exportBus(), 1, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.fluidExportBus(), 2, fluidIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.fluidExportBus(), 1, fluidIoBusGroup);
        Upgrades.SPEED.registerItem(parts.fluidExportBus(), 4, fluidIoBusGroup);
        Upgrades.FUZZY.registerItem(items.cell1k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell1k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.cell4k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell4k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.cell16k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell16k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.cell64k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell64k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell1k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell4k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell16k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell64k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell1k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell4k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell16k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell64k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.viewCell(), 1);
        Upgrades.INVERTER.registerItem(items.viewCell(), 1);
        Upgrades.FUZZY.registerItem(parts.storageBus(), 1);
        Upgrades.INVERTER.registerItem(parts.storageBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.storageBus(), 5);
        Upgrades.INVERTER.registerItem(parts.fluidStorageBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.fluidStorageBus(), 5);
        Upgrades.FUZZY.registerItem(parts.formationPlane(), 1);
        Upgrades.INVERTER.registerItem(parts.formationPlane(), 1);
        Upgrades.CAPACITY.registerItem(parts.formationPlane(), 5);
        Upgrades.FUZZY.registerItem(items.massCannon(), 1);
        Upgrades.INVERTER.registerItem(items.massCannon(), 1);
        Upgrades.SPEED.registerItem(items.massCannon(), 4);
        Upgrades.SPEED.registerItem(blocks.molecularAssembler(), 5);
        Upgrades.SPEED.registerItem(blocks.inscriber(), 3);
        items.wirelessTerminal().maybeItem().ifPresent(terminal -> registries.wireless().registerWirelessHandler((IWirelessTermHandler)terminal));
        items.chargedStaff().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((class_1792)chargedStaff, 320.0));
        items.portableCell1k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((class_1792)chargedStaff, 800.0));
        items.portableCell4k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((class_1792)chargedStaff, 800.0));
        items.portableCell16k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((class_1792)chargedStaff, 800.0));
        items.portableCell64k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((class_1792)chargedStaff, 800.0));
        items.colorApplicator().maybeItem().ifPresent(colorApplicator -> registries.charger().addChargeRate((class_1792)colorApplicator, 800.0));
        items.wirelessTerminal().maybeItem().ifPresent(terminal -> registries.charger().addChargeRate((class_1792)terminal, 8000.0));
        items.entropyManipulator().maybeItem().ifPresent(entropyManipulator -> registries.charger().addChargeRate((class_1792)entropyManipulator, 8000.0));
        items.massCannon().maybeItem().ifPresent(massCannon -> registries.charger().addChargeRate((class_1792)massCannon, 8000.0));
        blocks.energyCell().maybeItem().ifPresent(cell -> registries.charger().addChargeRate((class_1792)cell, 8000.0));
        blocks.energyCellDense().maybeItem().ifPresent(cell -> registries.charger().addChargeRate((class_1792)cell, 16000.0));
        IMovableRegistry mr = registries.movable();
        mr.blacklistBlock(class_2246.field_9987);
        mr.whiteListBlockEntity(class_2573.class);
        mr.whiteListBlockEntity(class_2580.class);
        mr.whiteListBlockEntity(class_2589.class);
        mr.whiteListBlockEntity(class_2595.class);
        mr.whiteListBlockEntity(class_2593.class);
        mr.whiteListBlockEntity(class_2599.class);
        mr.whiteListBlockEntity(class_2603.class);
        mr.whiteListBlockEntity(class_2601.class);
        mr.whiteListBlockEntity(class_2608.class);
        mr.whiteListBlockEntity(class_2605.class);
        mr.whiteListBlockEntity(class_2611.class);
        mr.whiteListBlockEntity(class_2640.class);
        mr.whiteListBlockEntity(class_3866.class);
        mr.whiteListBlockEntity(class_2614.class);
        mr.whiteListBlockEntity(class_2636.class);
        mr.whiteListBlockEntity(class_2669.class);
        mr.whiteListBlockEntity(class_2627.class);
        mr.whiteListBlockEntity(class_2625.class);
        mr.whiteListBlockEntity(class_2631.class);
        mr.whiteListBlockEntity(AEBaseBlockEntity.class);
    }

    protected void registerParticleTypes() {
        class_2378.method_10230((class_2378)class_2378.field_11141, (class_2960)AppEng.makeId("charged_ore_fx"), (Object)ParticleTypes.CHARGED_ORE);
        class_2378.method_10230((class_2378)class_2378.field_11141, (class_2960)AppEng.makeId("crafting_fx"), (Object)ParticleTypes.CRAFTING);
        class_2378.method_10230((class_2378)class_2378.field_11141, (class_2960)AppEng.makeId("energy_fx"), ParticleTypes.ENERGY);
        class_2378.method_10230((class_2378)class_2378.field_11141, (class_2960)AppEng.makeId("lightning_arc_fx"), ParticleTypes.LIGHTNING_ARC);
        class_2378.method_10230((class_2378)class_2378.field_11141, (class_2960)AppEng.makeId("lightning_fx"), (Object)ParticleTypes.LIGHTNING);
        class_2378.method_10230((class_2378)class_2378.field_11141, (class_2960)AppEng.makeId("matter_cannon_fx"), (Object)ParticleTypes.MATTER_CANNON);
        class_2378.method_10230((class_2378)class_2378.field_11141, (class_2960)AppEng.makeId("vibrant_fx"), (Object)ParticleTypes.VIBRANT);
    }

    private void registerBlockEntities() {
        this.callDeferredBootstrapComponents(ITileEntityRegistrationComponent.class, ITileEntityRegistrationComponent::register);
    }

    private void registerRecipeSerializers() {
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)AppEng.makeId("quartz_knife"), (Object)((Object)QuartzKnifeRecipeSerializer.INSTANCE));
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)GrinderRecipe.TYPE_ID, (Object)GrinderRecipeSerializer.INSTANCE);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)InscriberRecipe.TYPE_ID, (Object)InscriberRecipeSerializer.INSTANCE);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)AppEng.makeId("disassemble"), DisassembleRecipe.SERIALIZER);
        FacadeItem facadeItem = (FacadeItem)Api.INSTANCE.definitions().items().facade().item();
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)AppEng.makeId("facade"), FacadeRecipe.getSerializer(facadeItem));
    }

    @Override
    public AdvancementTriggers getAdvancementTriggers() {
        return this.advancementTriggers;
    }

    @Override
    public void sendToAllNearExcept(class_1657 p, double x, double y, double z, double dist, class_1937 w, BasePacket packet) {
        if (w.method_8608()) {
            return;
        }
        NetworkHandler.instance().sendToAllAround(packet, new TargetPoint(x, y, z, dist, w));
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        return this.getCableRenderModeForPlayer(this.partInteractionPlayer.get());
    }

    @Override
    public void setPartInteractionPlayer(class_1657 player) {
        this.partInteractionPlayer.set(player);
    }

    protected final <T extends IBootstrapComponent> void callDeferredBootstrapComponents(Class<T> componentClass, Consumer<T> invoker) {
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(componentClass).forEachRemaining(invoker);
    }

    protected final CableRenderMode getCableRenderModeForPlayer(@Nullable class_1657 player) {
        if (player != null) {
            for (int x = 0; x < class_1661.method_7368(); ++x) {
                class_2487 c;
                class_1799 is = player.field_7514.method_5438(x);
                if (is.method_7960() || !(is.method_7909() instanceof NetworkToolItem) || (c = is.method_7969()) == null || !c.method_10577("hideFacades")) continue;
                return CableRenderMode.CABLE_VIEW;
            }
        }
        return CableRenderMode.STANDARD;
    }

    private void registerScreenHandlerTypes() {
        CellWorkbenchContainer.TYPE = this.registerScreenHandler("cellworkbench", CellWorkbenchContainer::fromNetwork, CellWorkbenchContainer::open);
        ChestContainer.TYPE = this.registerScreenHandler("chest", ChestContainer::fromNetwork, ChestContainer::open);
        CondenserContainer.TYPE = this.registerScreenHandler("condenser", CondenserContainer::fromNetwork, CondenserContainer::open);
        CraftAmountContainer.TYPE = this.registerScreenHandler("craftamount", CraftAmountContainer::fromNetwork, CraftAmountContainer::open);
        CraftConfirmContainer.TYPE = this.registerScreenHandler("craftconfirm", CraftConfirmContainer::fromNetwork, CraftConfirmContainer::open);
        CraftingCPUContainer.TYPE = this.registerScreenHandler("craftingcpu", CraftingCPUContainer::fromNetwork, CraftingCPUContainer::open);
        CraftingStatusContainer.TYPE = this.registerScreenHandler("craftingstatus", CraftingStatusContainer::fromNetwork, CraftingStatusContainer::open);
        CraftingTermContainer.TYPE = this.registerScreenHandler("craftingterm", CraftingTermContainer::fromNetwork, CraftingTermContainer::open);
        DriveContainer.TYPE = this.registerScreenHandler("drive", DriveContainer::fromNetwork, DriveContainer::open);
        FormationPlaneContainer.TYPE = this.registerScreenHandler("formationplane", FormationPlaneContainer::fromNetwork, FormationPlaneContainer::open);
        GrinderContainer.TYPE = this.registerScreenHandler("grinder", GrinderContainer::fromNetwork, GrinderContainer::open);
        InscriberContainer.TYPE = this.registerScreenHandler("inscriber", InscriberContainer::fromNetwork, InscriberContainer::open);
        InterfaceContainer.TYPE = this.registerScreenHandler("interface", InterfaceContainer::fromNetwork, InterfaceContainer::open);
        InterfaceTerminalContainer.TYPE = this.registerScreenHandler("interfaceterminal", InterfaceTerminalContainer::fromNetwork, InterfaceTerminalContainer::open);
        IOPortContainer.TYPE = this.registerScreenHandler("ioport", IOPortContainer::fromNetwork, IOPortContainer::open);
        LevelEmitterContainer.TYPE = this.registerScreenHandler("levelemitter", LevelEmitterContainer::fromNetwork, LevelEmitterContainer::open);
        MolecularAssemblerContainer.TYPE = this.registerScreenHandler("molecular_assembler", MolecularAssemblerContainer::fromNetwork, MolecularAssemblerContainer::open);
        MEMonitorableContainer.TYPE = this.registerScreenHandler("memonitorable", MEMonitorableContainer::fromNetwork, MEMonitorableContainer::open);
        MEPortableCellContainer.TYPE = this.registerScreenHandler("meportablecell", MEPortableCellContainer::fromNetwork, MEPortableCellContainer::open);
        NetworkStatusContainer.TYPE = this.registerScreenHandler("networkstatus", NetworkStatusContainer::fromNetwork, NetworkStatusContainer::open);
        NetworkToolContainer.TYPE = this.registerScreenHandler("networktool", NetworkToolContainer::fromNetwork, NetworkToolContainer::open);
        PatternTermContainer.TYPE = this.registerScreenHandler("patternterm", PatternTermContainer::fromNetwork, PatternTermContainer::open);
        PriorityContainer.TYPE = this.registerScreenHandler("priority", PriorityContainer::fromNetwork, PriorityContainer::open);
        QNBContainer.TYPE = this.registerScreenHandler("qnb", QNBContainer::fromNetwork, QNBContainer::open);
        QuartzKnifeContainer.TYPE = this.registerScreenHandler("quartzknife", QuartzKnifeContainer::fromNetwork, QuartzKnifeContainer::open);
        SecurityStationContainer.TYPE = this.registerScreenHandler("securitystation", SecurityStationContainer::fromNetwork, SecurityStationContainer::open);
        SkyChestContainer.TYPE = this.registerScreenHandler("skychest", SkyChestContainer::fromNetwork, SkyChestContainer::open);
        SpatialIOPortContainer.TYPE = this.registerScreenHandler("spatialioport", SpatialIOPortContainer::fromNetwork, SpatialIOPortContainer::open);
        StorageBusContainer.TYPE = this.registerScreenHandler("storagebus", StorageBusContainer::fromNetwork, StorageBusContainer::open);
        UpgradeableContainer.TYPE = this.registerScreenHandler("upgradeable", UpgradeableContainer::fromNetwork, UpgradeableContainer::open);
        VibrationChamberContainer.TYPE = this.registerScreenHandler("vibrationchamber", VibrationChamberContainer::fromNetwork, VibrationChamberContainer::open);
        WirelessContainer.TYPE = this.registerScreenHandler("wireless", WirelessContainer::fromNetwork, WirelessContainer::open);
        WirelessTermContainer.TYPE = this.registerScreenHandler("wirelessterm", WirelessTermContainer::fromNetwork, WirelessTermContainer::open);
        FluidFormationPlaneContainer.TYPE = this.registerScreenHandler("fluid_formation_plane", FluidFormationPlaneContainer::fromNetwork, FluidFormationPlaneContainer::open);
        FluidIOContainer.TYPE = this.registerScreenHandler("fluid_io", FluidIOContainer::fromNetwork, FluidIOContainer::open);
        FluidInterfaceContainer.TYPE = this.registerScreenHandler("fluid_interface", FluidInterfaceContainer::fromNetwork, FluidInterfaceContainer::open);
        FluidLevelEmitterContainer.TYPE = this.registerScreenHandler("fluid_level_emitter", FluidLevelEmitterContainer::fromNetwork, FluidLevelEmitterContainer::open);
        FluidStorageBusContainer.TYPE = this.registerScreenHandler("fluid_storage_bus", FluidStorageBusContainer::fromNetwork, FluidStorageBusContainer::open);
        FluidTerminalContainer.TYPE = this.registerScreenHandler("fluid_terminal", FluidTerminalContainer::fromNetwork, FluidTerminalContainer::open);
    }

    private <T extends AEBaseContainer> class_3917<T> registerScreenHandler(String id, ScreenHandlerRegistry.ExtendedClientHandlerFactory<T> factory, ContainerOpener.Opener<T> opener) {
        class_3917 type = ScreenHandlerRegistry.registerExtended((class_2960)AppEng.makeId(id), factory);
        ContainerOpener.addOpener(type, opener);
        return type;
    }

    private void registerServerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> new AECommand().register((CommandDispatcher<class_2168>)dispatcher));
    }
}

