/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.CreativeTab;
import appeng.core.FacadeCreativeTab;
import appeng.mixins.feature.ConfiguredFeaturesAccessor;
import appeng.mixins.structure.ConfiguredStructureFeaturesAccessor;
import appeng.mixins.structure.StructureFeatureAccessor;
import appeng.spatial.SpatialStorageChunkGenerator;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.worldgen.BiomeModifier;
import appeng.worldgen.ChargedQuartzOreConfig;
import appeng.worldgen.ChargedQuartzOreFeature;
import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2997;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3113;
import net.minecraft.class_3124;
import net.minecraft.class_3284;
import net.minecraft.class_5321;
import net.minecraft.class_5458;

public final class AppEngBootstrap {
    private static boolean initialized;

    private AppEngBootstrap() {
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        AEConfig.load(FabricLoader.getInstance().getConfigDirectory());
        CreativeTab.init();
        FacadeCreativeTab.init();
        Api.INSTANCE = new Api();
        AppEngBootstrap.registerStructures();
        class_2975<?, ?> quartzOreFeature = AppEngBootstrap.registerQuartzOreFeature();
        class_2975<?, ?> chargedQuartzOreFeature = AppEngBootstrap.registerChargedQuartzOreFeature();
        HashSet<String> meteoriteBiomeBlacklist = new HashSet<String>(AEConfig.instance().getMeteoriteBiomeBlacklist());
        HashSet<String> quartzOreBiomeBlacklist = new HashSet<String>(AEConfig.instance().getQuartzOreBiomeBlacklist());
        for (Map.Entry entry : class_5458.field_25933.method_29722()) {
            class_2960 id2 = ((class_5321)entry.getKey()).method_29177();
            class_1959 b = (class_1959)entry.getValue();
            AppEngBootstrap.addMeteoriteWorldGen(id2, b, meteoriteBiomeBlacklist);
            AppEngBootstrap.addQuartzWorldGen(id2, b, quartzOreFeature, chargedQuartzOreFeature, quartzOreBiomeBlacklist);
        }
        RegistryEntryAddedCallback.event((class_2378)class_5458.field_25933).register((i, id, biome) -> {
            AppEngBootstrap.addMeteoriteWorldGen(id, biome, meteoriteBiomeBlacklist);
            AppEngBootstrap.addQuartzWorldGen(id, biome, quartzOreFeature, chargedQuartzOreFeature, quartzOreBiomeBlacklist);
        });
        AppEngBootstrap.registerDimension();
    }

    private static void registerStructures() {
        MeteoriteStructurePiece.register();
        StructureFeatureAccessor.register(MeteoriteStructure.ID.toString(), MeteoriteStructure.INSTANCE, class_2893.class_2895.field_13179);
        ConfiguredStructureFeaturesAccessor.register(MeteoriteStructure.ID.toString(), MeteoriteStructure.CONFIGURED_INSTANCE);
    }

    private static void addMeteoriteWorldGen(class_2960 id, class_1959 b, Set<String> biomeBlacklist) {
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            AELog.debug("Not generating meteorites in %s because the feature is disabled", id);
            return;
        }
        if (AppEngBootstrap.isBlacklistedBiomeCategory(b.method_8688())) {
            AELog.debug("Not generating meteorites in %s because it's of category %s", id, b.method_8688());
            return;
        }
        if (biomeBlacklist.contains(id.toString())) {
            AELog.debug("Not generating meteorites in %s because the biome is blacklisted in the config", id);
            return;
        }
        BiomeModifier modifier = new BiomeModifier(b);
        modifier.addStructureFeature(MeteoriteStructure.CONFIGURED_INSTANCE);
    }

    private static void addQuartzWorldGen(class_2960 id, class_1959 b, class_2975<?, ?> quartzOre, class_2975<?, ?> chargedQuartz, Set<String> biomeBlacklist) {
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN)) {
            AELog.debug("Not generating quartz-ore in %s because the feature is disabled", id);
            return;
        }
        if (AppEngBootstrap.isBlacklistedBiomeCategory(b.method_8688())) {
            AELog.debug("Not generating quartz ore in %s because it's of category %s", id, b.method_8688());
            return;
        }
        if (biomeBlacklist.contains(id.toString())) {
            AELog.debug("Not generating quartz-ore in %s because the biome is blacklisted in the config", id);
            return;
        }
        BiomeModifier modifier = new BiomeModifier(b);
        modifier.addFeature(class_2893.class_2895.field_13176, quartzOre);
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CHARGED_CERTUS_ORE)) {
            modifier.addFeature(class_2893.class_2895.field_13177, chargedQuartz);
        }
    }

    private static boolean isBlacklistedBiomeCategory(class_1959.class_1961 category) {
        return category == class_1959.class_1961.field_9360 || category == class_1959.class_1961.field_9366 || category == class_1959.class_1961.field_9371;
    }

    private static class_2975<?, ?> registerQuartzOreFeature() {
        class_2680 quartzOreState = Api.instance().definitions().blocks().quartzOre().block().method_9564();
        return ConfiguredFeaturesAccessor.register(AppEng.makeId("quartz_ore").toString(), (class_2975)((class_2975)class_3031.field_13517.method_23397((class_3037)new class_3124(class_3124.class_5436.field_25845, quartzOreState, AEConfig.instance().getQuartzOresPerCluster())).method_23388(class_3284.field_25870.method_23475((class_2998)new class_2997(12, 12, 72))).method_30371()).method_30375(AEConfig.instance().getQuartzOresClusterAmount()));
    }

    private static class_2975<?, ?> registerChargedQuartzOreFeature() {
        class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)AppEng.makeId("charged_quartz_ore"), (Object)((Object)ChargedQuartzOreFeature.INSTANCE));
        class_2680 quartzOreState = Api.instance().definitions().blocks().quartzOre().block().method_9564();
        class_2680 chargedQuartzOreState = Api.instance().definitions().blocks().quartzOreCharged().block().method_9564();
        return ConfiguredFeaturesAccessor.register(AppEng.makeId("charged_quartz_ore").toString(), ChargedQuartzOreFeature.INSTANCE.method_23397(new ChargedQuartzOreConfig(quartzOreState, chargedQuartzOreState, AEConfig.instance().getSpawnChargedChance())).method_23388(class_3284.field_14250.method_23475((class_2998)class_3113.field_24892)));
    }

    private static void registerDimension() {
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)SpatialStorageDimensionIds.CHUNK_GENERATOR_ID, SpatialStorageChunkGenerator.CODEC);
    }
}

