/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.client.ICellModelRegistry;
import appeng.api.client.IClientHelper;
import appeng.api.config.IncludeExclude;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.core.ApiDefinitions;
import appeng.core.api.client.ApiCellModelRegistry;
import appeng.core.localization.GuiText;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

public class ApiClientHelper
implements IClientHelper {
    private final ICellModelRegistry cells;

    public ApiClientHelper(ApiDefinitions definitions) {
        this.cells = new ApiCellModelRegistry(definitions);
    }

    @Override
    public <T extends IAEStack<T>> void addCellInformation(ICellInventoryHandler<T> handler, List<class_2561> lines) {
        if (handler == null) {
            return;
        }
        ICellInventory<T> cellInventory = handler.getCellInv();
        if (cellInventory != null) {
            lines.add((class_2561)new class_2585(cellInventory.getUsedBytes() + " ").method_10852(GuiText.Of.text()).method_27693(" " + cellInventory.getTotalBytes() + " ").method_10852(GuiText.BytesUsed.text()));
            lines.add((class_2561)new class_2585(cellInventory.getStoredItemTypes() + " ").method_10852(GuiText.Of.text()).method_27693(" " + cellInventory.getTotalItemTypes() + " ").method_10852(GuiText.Types.text()));
        }
        if (handler.isPreformatted()) {
            String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
            if (handler.isFuzzy()) {
                lines.add((class_2561)GuiText.Partitioned.text().method_27662().method_27693(" - " + list + " ").method_10852(GuiText.Fuzzy.text()));
            } else {
                lines.add((class_2561)GuiText.Partitioned.text().method_27662().method_27693(" - " + list + " ").method_10852(GuiText.Precise.text()));
            }
        }
    }

    @Override
    public ICellModelRegistry cells() {
        return this.cells;
    }
}

