/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.helpers.CraftingPatternDetails;
import appeng.items.misc.EncodedPatternItem;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class ApiCrafting
implements ICraftingHelper {
    private final IItemDefinition encodedPattern;

    public ApiCrafting(ApiDefinitions definitions) {
        this.encodedPattern = definitions.items().encodedPattern();
    }

    @Override
    public boolean isEncodedPattern(@Nullable IAEItemStack item) {
        return item != null && item.getItem() instanceof EncodedPatternItem;
    }

    @Override
    public boolean isEncodedPattern(class_1799 item) {
        return !item.method_7960() && item.method_7909() instanceof EncodedPatternItem;
    }

    @Override
    public class_1799 encodeCraftingPattern(@Nullable class_1799 stack, class_3955 recipe, class_1799[] in, class_1799 out, boolean allowSubstitutes) {
        if (stack == null) {
            stack = this.encodedPattern.stack(1);
        } else {
            Preconditions.checkArgument((boolean)this.isEncodedPattern(stack));
        }
        EncodedPatternItem.encodeCraftingPattern(stack, in, new class_1799[]{out}, recipe.method_8114(), allowSubstitutes);
        return stack;
    }

    @Override
    public class_1799 encodeProcessingPattern(@Nullable class_1799 stack, class_1799[] in, class_1799[] out) {
        if (stack == null) {
            stack = this.encodedPattern.stack(1);
        } else {
            Preconditions.checkArgument((boolean)this.isEncodedPattern(stack));
        }
        EncodedPatternItem.encodeProcessingPattern(stack, in, out);
        return stack;
    }

    @Override
    public ICraftingPatternDetails decodePattern(class_1799 is, class_1937 world, boolean autoRecovery) {
        class_1860 recipe;
        if (is == null || world == null) {
            return null;
        }
        EncodedPatternItem patternItem = ApiCrafting.getPatternItem(is);
        if (patternItem == null || !patternItem.isEncodedPattern(is)) {
            return null;
        }
        class_2960 recipeId = patternItem.getCraftingRecipeId(is);
        if (!(recipeId == null || (recipe = (class_1860)world.method_8433().method_17717(class_3956.field_17545).get(recipeId)) instanceof class_3955 || autoRecovery && this.attemptRecovery(patternItem, is, world))) {
            return null;
        }
        IAEItemStack ais = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(is);
        try {
            return new CraftingPatternDetails(ais, world);
        }
        catch (IllegalStateException e) {
            AELog.warn("Could not decode an invalid pattern %s: %s", is, e);
            return null;
        }
    }

    private boolean attemptRecovery(EncodedPatternItem patternItem, class_1799 itemStack, class_1937 world) {
        class_1863 recipeManager = world.method_8433();
        List<IAEItemStack> ingredients = patternItem.getIngredients(itemStack);
        List<IAEItemStack> products = patternItem.getProducts(itemStack);
        if (ingredients.size() < 9 || products.size() < 1) {
            return false;
        }
        class_2960 currentRecipeId = patternItem.getCraftingRecipeId(itemStack);
        class_1715 testInventory = new class_1715((class_1703)new ContainerNull(), 3, 3);
        for (int x = 0; x < 9; ++x) {
            IAEItemStack ais2 = ingredients.get(x);
            class_1799 gs = ais2 != null ? ais2.createItemStack() : class_1799.field_8037;
            testInventory.method_5447(x, gs);
        }
        class_3955 potentialRecipe = recipeManager.method_8132(class_3956.field_17545, (class_1263)testInventory, world).orElse(null);
        if (potentialRecipe != null && products.get(0).isSameType(potentialRecipe.method_8116((class_1263)testInventory))) {
            AELog.debug("Re-Encoding pattern from %s -> %s", currentRecipeId, potentialRecipe.method_8114());
            class_1799[] in = (class_1799[])ingredients.stream().map(ais -> ais != null ? ais.createItemStack() : class_1799.field_8037).toArray(class_1799[]::new);
            class_1799 out = products.get(0).createItemStack();
            this.encodeCraftingPattern(itemStack, potentialRecipe, in, out, patternItem.allowsSubstitution(itemStack));
        }
        AELog.debug("Failed to recover encoded crafting pattern for recipe %s", currentRecipeId);
        return false;
    }

    private static EncodedPatternItem getPatternItem(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof EncodedPatternItem) {
            return (EncodedPatternItem)itemStack.method_7909();
        }
        return null;
    }
}

