/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api.client;

import appeng.api.client.ICellModelRegistry;
import appeng.core.ApiDefinitions;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class ApiCellModelRegistry
implements ICellModelRegistry {
    private static final class_2960 MODEL_BASE = new class_2960("appliedenergistics2:block/drive/drive_base");
    private static final class_2960 MODEL_CELL_EMPTY = new class_2960("appliedenergistics2:block/drive/drive_cell_empty");
    private static final class_2960 MODEL_CELL_DEFAULT = new class_2960("appliedenergistics2:block/drive/drive_cell");
    private static final class_2960 MODEL_CELL_ITEMS_1K = new class_2960("appliedenergistics2:block/drive/cells/1k_item_cell");
    private static final class_2960 MODEL_CELL_ITEMS_4K = new class_2960("appliedenergistics2:block/drive/cells/4k_item_cell");
    private static final class_2960 MODEL_CELL_ITEMS_16K = new class_2960("appliedenergistics2:block/drive/cells/16k_item_cell");
    private static final class_2960 MODEL_CELL_ITEMS_64K = new class_2960("appliedenergistics2:block/drive/cells/64k_item_cell");
    private static final class_2960 MODEL_CELL_FLUIDS_1K = new class_2960("appliedenergistics2:block/drive/cells/1k_fluid_cell");
    private static final class_2960 MODEL_CELL_FLUIDS_4K = new class_2960("appliedenergistics2:block/drive/cells/4k_fluid_cell");
    private static final class_2960 MODEL_CELL_FLUIDS_16K = new class_2960("appliedenergistics2:block/drive/cells/16k_fluid_cell");
    private static final class_2960 MODEL_CELL_FLUIDS_64K = new class_2960("appliedenergistics2:block/drive/cells/64k_fluid_cell");
    private static final class_2960 MODEL_CELL_CREATIVE = new class_2960("appliedenergistics2:block/drive/cells/creative_cell");
    private static final class_2960[] MODELS = new class_2960[]{MODEL_BASE, MODEL_CELL_EMPTY, MODEL_CELL_DEFAULT, MODEL_CELL_ITEMS_1K, MODEL_CELL_ITEMS_4K, MODEL_CELL_ITEMS_16K, MODEL_CELL_ITEMS_64K, MODEL_CELL_FLUIDS_1K, MODEL_CELL_FLUIDS_4K, MODEL_CELL_FLUIDS_16K, MODEL_CELL_FLUIDS_64K, MODEL_CELL_CREATIVE};
    private final Map<class_1792, class_2960> registry = new IdentityHashMap<class_1792, class_2960>();

    public static Collection<class_2960> getModels() {
        return Arrays.asList(MODELS);
    }

    public ApiCellModelRegistry(ApiDefinitions definitions) {
        this.registry.put(definitions.items().cell1k().item(), MODEL_CELL_ITEMS_1K);
        this.registry.put(definitions.items().cell4k().item(), MODEL_CELL_ITEMS_4K);
        this.registry.put(definitions.items().cell16k().item(), MODEL_CELL_ITEMS_16K);
        this.registry.put(definitions.items().cell64k().item(), MODEL_CELL_ITEMS_64K);
        this.registry.put(definitions.items().fluidCell1k().item(), MODEL_CELL_FLUIDS_1K);
        this.registry.put(definitions.items().fluidCell4k().item(), MODEL_CELL_FLUIDS_4K);
        this.registry.put(definitions.items().fluidCell16k().item(), MODEL_CELL_FLUIDS_16K);
        this.registry.put(definitions.items().fluidCell64k().item(), MODEL_CELL_FLUIDS_64K);
        this.registry.put(definitions.items().fluidCell64k().item(), MODEL_CELL_FLUIDS_64K);
        this.registry.put(definitions.items().cellCreative().item(), MODEL_CELL_CREATIVE);
    }

    @Override
    public void registerModel(class_1792 item, class_2960 model) {
        Preconditions.checkNotNull((Object)item);
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkArgument((!this.registry.containsKey(item) ? 1 : 0) != 0, (Object)"Cannot register an item twice.");
        this.registry.put(item, model);
    }

    @Override
    @Nullable
    public class_2960 model(@Nonnull class_1792 item) {
        Preconditions.checkNotNull((Object)item);
        return this.registry.get(item);
    }

    @Override
    @Nonnull
    public Map<class_1792, class_2960> models() {
        return Collections.unmodifiableMap(this.registry);
    }

    @Override
    @Nonnull
    public class_2960 getDefaultModel() {
        return MODEL_CELL_DEFAULT;
    }
}

