/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.ConfigSection;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class ConfigFileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private final ConfigSection rootSection;
    private final File file;
    private boolean loading;

    public ConfigFileManager(ConfigSection rootSection, File file) {
        this.rootSection = rootSection;
        this.file = file;
        rootSection.setChangeListener(() -> {
            if (!this.loading) {
                this.save();
            }
        });
    }

    public void load() {
        this.loading = true;
        try (FileInputStream in2 = new FileInputStream(this.file);){
            JsonObject rootObj = (JsonObject)GSON.fromJson((Reader)new InputStreamReader((InputStream)in2, StandardCharsets.UTF_8), JsonObject.class);
            this.rootSection.read(rootObj);
        }
        catch (FileNotFoundException in2) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load AE2 config: " + this.file, e);
        }
        finally {
            this.loading = false;
        }
    }

    public void save() {
        File parent = this.file.getParentFile();
        if (parent != null && !parent.exists()) {
            try {
                Files.createDirectories(parent.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create AE2 config directory: " + parent);
            }
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)this.rootSection.write(), (Appendable)writer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write AE2 config: " + this.file, e);
        }
        this.rootSection.write();
    }
}

