/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.api.features.AEFeature;
import appeng.core.features.IStackSrc;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class DamagedItemDefinition
implements IItemDefinition {
    private final String identifier;
    private final IStackSrc source;

    public DamagedItemDefinition(@Nonnull String identifier, @Nonnull IStackSrc source) {
        this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
        this.source = (IStackSrc)Preconditions.checkNotNull((Object)source);
    }

    @Override
    public class_1792 item() {
        return this.source.getItem();
    }

    @Override
    public class_1799 stack(int stackSize) {
        return this.source.stack(stackSize);
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Optional<class_1792> maybeItem() {
        return Optional.of(this.source.getItem());
    }

    @Override
    public Optional<class_1799> maybeStack(int stackSize) {
        return Optional.of(this.source.stack(stackSize));
    }

    @Override
    public Set<AEFeature> features() {
        return Collections.emptySet();
    }

    @Override
    public boolean isSameAs(class_1799 comparableStack) {
        if (comparableStack.method_7960()) {
            return false;
        }
        return comparableStack.method_7909() == this.source.getItem();
    }
}

