/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.api.features.AEFeature;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class ItemDefinition
implements IItemDefinition {
    private final String identifier;
    private final class_1792 item;
    private final Set<AEFeature> features;

    public ItemDefinition(String registryName, class_1792 item, Set<AEFeature> features) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)registryName) ? 1 : 0) != 0, (Object)"registryName");
        this.identifier = registryName;
        this.item = item;
        this.features = ImmutableSet.copyOf(features);
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    public final class_1792 item() {
        return this.item;
    }

    @Override
    public class_1799 stack(int stackSize) {
        return new class_1799((class_1935)this.item, stackSize);
    }

    @Override
    public Set<AEFeature> features() {
        return this.features;
    }

    @Override
    public final boolean isSameAs(class_1799 comparableStack) {
        return Platform.itemComparisons().isEqualItemType(comparableStack, this.stack(1));
    }
}

