/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.events.LocatableEventAnnounce;
import appeng.api.features.ILocatable;
import appeng.api.features.ILocatableRegistry;
import appeng.core.AELog;
import appeng.util.Platform;
import java.util.HashMap;
import java.util.Map;

public final class LocatableRegistry
implements ILocatableRegistry {
    private final Map<Long, ILocatable> set = new HashMap<Long, ILocatable>();

    public LocatableRegistry() {
        LocatableEventAnnounce.EVENT.register((target, change) -> {
            if (Platform.isClient()) {
                return;
            }
            if (change == LocatableEventAnnounce.LocatableEvent.REGISTER) {
                AELog.debug("Registering locatable %s: %s", target.getLocatableSerial(), target);
                this.set.put(target.getLocatableSerial(), target);
            } else if (change == LocatableEventAnnounce.LocatableEvent.UNREGISTER) {
                AELog.debug("Unregistering locatable %s: %s", target.getLocatableSerial(), target);
                this.set.remove(target.getLocatableSerial());
            }
        });
    }

    @Override
    public ILocatable getLocatableBy(long serial) {
        return this.set.get(serial);
    }
}

