/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.exceptions.AppEngException;
import appeng.api.movable.IMovableHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.movable.IMovableTile;
import appeng.core.AEConfig;
import appeng.mixins.tags.BlockTagsAccessor;
import appeng.spatial.DefaultSpatialHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class MovableTileRegistry
implements IMovableRegistry {
    private static final class_2960 TAG_WHITELIST = new class_2960("appliedenergistics2", "spatial/whitelist");
    private static final class_2960 TAG_BLACKLIST = new class_2960("appliedenergistics2", "spatial/blacklist");
    private final Set<class_2248> blacklisted = new HashSet<class_2248>();
    private final Map<Class<? extends class_2586>, IMovableHandler> valid = new IdentityHashMap<Class<? extends class_2586>, IMovableHandler>();
    private final List<Class<? extends class_2586>> test = new ArrayList<Class<? extends class_2586>>();
    private final List<IMovableHandler> handlers = new ArrayList<IMovableHandler>();
    private final DefaultSpatialHandler dsh = new DefaultSpatialHandler();
    private final IMovableHandler nullHandler = new DefaultSpatialHandler();
    private final class_3494.class_5123<class_2248> blockTagWhiteList = BlockTagsAccessor.register(TAG_WHITELIST.toString());
    private final class_3494.class_5123<class_2248> blockTagBlackList = BlockTagsAccessor.register(TAG_BLACKLIST.toString());

    @Override
    public void blacklistBlock(class_2248 blk) {
        this.blacklisted.add(blk);
    }

    @Override
    public void whiteListBlockEntity(Class<? extends class_2586> c) {
        if (c.getName().equals(class_2586.class.getName())) {
            throw new IllegalArgumentException(new AppEngException("Someone tried to make all tiles movable with " + c + ", this is a clear violation of the purpose of the white list."));
        }
        this.test.add(c);
    }

    @Override
    public boolean askToMove(class_2586 te) {
        Class<?> myClass = te.getClass();
        IMovableHandler canMove = this.valid.get(myClass);
        if (canMove == null) {
            canMove = this.testClass(myClass, te);
        }
        if (canMove != this.nullHandler) {
            if (te instanceof IMovableTile) {
                ((IMovableTile)te).prepareToMove();
            }
            te.method_11012();
            return true;
        }
        return false;
    }

    private IMovableHandler testClass(Class<? extends class_2586> myClass, class_2586 te) {
        IMovableHandler handler = null;
        for (IMovableHandler iMovableHandler : this.handlers) {
            if (!iMovableHandler.canHandle(myClass, te)) continue;
            handler = iMovableHandler;
            break;
        }
        if (handler != null) {
            this.valid.put(myClass, handler);
            return handler;
        }
        if (te instanceof IMovableTile) {
            this.valid.put(myClass, this.dsh);
            return this.dsh;
        }
        if (AEConfig.instance().getSpatialBlockTags() && this.blockTagWhiteList.method_15141((Object)te.method_11010().method_26204())) {
            this.valid.put(myClass, this.dsh);
            return this.dsh;
        }
        for (Class clazz : this.test) {
            if (!clazz.isAssignableFrom(myClass)) continue;
            this.valid.put(myClass, this.dsh);
            return this.dsh;
        }
        this.valid.put(myClass, this.nullHandler);
        return this.nullHandler;
    }

    @Override
    public void doneMoving(class_2586 te) {
        if (te instanceof IMovableTile) {
            IMovableTile mt = (IMovableTile)te;
            mt.doneMoving();
        }
    }

    @Override
    public void addHandler(IMovableHandler han) {
        this.handlers.add(han);
    }

    @Override
    public IMovableHandler getHandler(class_2586 te) {
        Class<?> myClass = te.getClass();
        IMovableHandler h = this.valid.get(myClass);
        return h == null ? this.dsh : h;
    }

    @Override
    public IMovableHandler getDefaultHandler() {
        return this.dsh;
    }

    @Override
    public boolean isBlacklisted(class_2248 blk) {
        return this.blacklisted.contains(blk) || this.blockTagBlackList.method_15141((Object)blk);
    }
}

