/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.util.AEColor;
import appeng.core.Api;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class P2PTunnelRegistry
implements IP2PTunnelRegistry {
    private static final int INITIAL_CAPACITY = 40;
    private final Map<class_1799, TunnelType> tunnels = new HashMap<class_1799, TunnelType>(40);
    private final Map<String, TunnelType> modIdTunnels = new HashMap<String, TunnelType>(40);
    private final Map<Attribute<?>, TunnelType> attrTunnels = new HashMap(40);

    public void configure() {
        IDefinitions definitions = Api.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IParts parts = definitions.parts();
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10336), TunnelType.LIGHT);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10171), TunnelType.LIGHT);
        this.addNewAttunement(new class_1799((class_1935)class_1802.field_8725), TunnelType.REDSTONE);
        this.addNewAttunement(new class_1799((class_1935)class_1802.field_8619), TunnelType.REDSTONE);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10524), TunnelType.REDSTONE);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10377), TunnelType.REDSTONE);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10429), TunnelType.REDSTONE);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10091), TunnelType.REDSTONE);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10002), TunnelType.REDSTONE);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10363), TunnelType.REDSTONE);
        this.addNewAttunement(blocks.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.storageBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.importBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.exportBus(), TunnelType.ITEM);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10312), TunnelType.ITEM);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10034), TunnelType.ITEM);
        this.addNewAttunement(new class_1799((class_1935)class_2246.field_10380), TunnelType.ITEM);
        this.addNewAttunement(new class_1799((class_1935)class_1802.field_8550), TunnelType.FLUID);
        this.addNewAttunement(new class_1799((class_1935)class_1802.field_8187), TunnelType.FLUID);
        this.addNewAttunement(new class_1799((class_1935)class_1802.field_8103), TunnelType.FLUID);
        this.addNewAttunement(new class_1799((class_1935)class_1802.field_8705), TunnelType.FLUID);
        for (AEColor c : AEColor.values()) {
            this.addNewAttunement(parts.cableGlass().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableCovered().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableSmart().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableDenseSmart().stack(c, 1), TunnelType.ME);
        }
        this.addNewAttunement((Attribute<?>)FluidAttributes.EXTRACTABLE, TunnelType.FLUID);
        this.addNewAttunement((Attribute<?>)FluidAttributes.INSERTABLE, TunnelType.FLUID);
        this.addNewAttunement((Attribute<?>)FluidAttributes.FIXED_INV, TunnelType.FLUID);
        this.addNewAttunement((Attribute<?>)FluidAttributes.GROUPED_INV, TunnelType.FLUID);
    }

    @Override
    public void addNewAttunement(@Nonnull String modId, @Nullable TunnelType type) {
        if (type == null || modId == null) {
            return;
        }
        this.modIdTunnels.put(modId, type);
    }

    @Override
    public void addNewAttunement(@Nonnull Attribute<?> attr, @Nullable TunnelType type) {
        if (type == null || attr == null) {
            return;
        }
        this.attrTunnels.put(attr, type);
    }

    @Override
    public void addNewAttunement(@Nonnull class_1799 trigger, @Nullable TunnelType type) {
        if (type == null || trigger.method_7960()) {
            return;
        }
        this.tunnels.put(trigger, type);
    }

    @Override
    @Nullable
    public TunnelType getTunnelTypeByItem(class_1799 trigger) {
        if (!trigger.method_7960()) {
            for (Map.Entry<class_1799, TunnelType> entry : this.tunnels.entrySet()) {
                class_1799 is = entry.getKey();
                if (is.method_7909() == trigger.method_7909()) {
                    return entry.getValue();
                }
                if (!class_1799.method_7987((class_1799)is, (class_1799)trigger)) continue;
                return entry.getValue();
            }
            for (Map.Entry<class_1799, TunnelType> entry : this.attrTunnels.entrySet()) {
                if (((Attribute)entry.getKey()).getFirstOrNull(trigger) == null) continue;
                return entry.getValue();
            }
            class_2960 itemId = class_2378.field_11142.method_10221((Object)trigger.method_7909());
            if (itemId == class_2378.field_11142.method_10137()) {
                return null;
            }
            for (Map.Entry<String, TunnelType> entry : this.modIdTunnels.entrySet()) {
                if (!itemId.method_12836().equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Nonnull
    private class_1799 getModItem(String modID, String name) {
        class_1792 item = class_2378.field_11142.method_17966(new class_2960(modID, name)).orElse(null);
        if (item == null) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)item);
    }

    private void addNewAttunement(IItemDefinition definition, TunnelType type) {
        definition.maybeStack(1).ifPresent(definitionStack -> this.addNewAttunement((class_1799)definitionStack, type));
    }
}

