/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWirelessTermRegistry;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.Api;
import appeng.core.localization.PlayerMessages;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;

public final class WirelessRegistry
implements IWirelessTermRegistry {
    private final List<IWirelessTermHandler> handlers = new ArrayList<IWirelessTermHandler>();

    @Override
    public void registerWirelessHandler(IWirelessTermHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    @Override
    public boolean isWirelessTerminal(class_1799 is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IWirelessTermHandler getWirelessTerminalHandler(class_1799 is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return h;
        }
        return null;
    }

    @Override
    public void openWirelessTerminalGui(class_1799 item, class_1922 world, class_1657 player, class_1268 hand) {
        if (Platform.isClient()) {
            return;
        }
        if (!this.isWirelessTerminal(item)) {
            player.method_9203(PlayerMessages.DeviceNotWirelessTerminal.get(), class_156.field_25140);
            return;
        }
        IWirelessTermHandler handler = this.getWirelessTerminalHandler(item);
        String unparsedKey = handler.getEncryptionKey(item);
        if (unparsedKey.isEmpty()) {
            player.method_9203(PlayerMessages.DeviceNotLinked.get(), class_156.field_25140);
            return;
        }
        long parsedKey = Long.parseLong(unparsedKey);
        ILocatable securityStation = Api.instance().registries().locatable().getLocatableBy(parsedKey);
        if (securityStation == null) {
            player.method_9203(PlayerMessages.StationCanNotBeLocated.get(), class_156.field_25140);
            return;
        }
        if (handler.hasPower(player, 0.5, item)) {
            ContainerOpener.openContainer(WirelessTermContainer.TYPE, player, ContainerLocator.forHand(player, hand));
        } else {
            player.method_9203(PlayerMessages.DeviceNotPowered.get(), class_156.field_25140);
        }
    }
}

