/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.cell;

import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.data.IAEStack;
import appeng.core.features.registries.cell.BasicCellHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;

public class CellRegistry
implements ICellRegistry {
    private final List<ICellHandler> handlers = new ArrayList<ICellHandler>();
    private final List<ICellGuiHandler> guiHandlers = new ArrayList<ICellGuiHandler>();

    @Override
    public void addCellHandler(ICellHandler handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"Called before FMLCommonSetupEvent.");
        Preconditions.checkArgument((!this.handlers.contains(handler) ? 1 : 0) != 0, (Object)"Tried to register the same handler instance twice.");
        this.handlers.add(handler);
        Verify.verify((boolean)(this.handlers.get(0) instanceof BasicCellHandler));
    }

    @Override
    public boolean isCellHandled(class_1799 is) {
        if (is.method_7960()) {
            return false;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICellHandler getHandler(class_1799 is) {
        if (is.method_7960()) {
            return null;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return ch;
        }
        return null;
    }

    @Override
    public <T extends IAEStack<T>> ICellInventoryHandler<T> getCellInventory(class_1799 is, ISaveProvider container, IStorageChannel<T> chan) {
        if (is.method_7960()) {
            return null;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return ch.getCellInventory(is, container, chan);
        }
        return null;
    }

    @Override
    public void addCellGuiHandler(ICellGuiHandler handler) {
        this.guiHandlers.add(handler);
    }

    @Override
    public <T extends IAEStack<T>> ICellGuiHandler getGuiHandler(IStorageChannel<T> channel, class_1799 is) {
        ICellGuiHandler fallBack = null;
        for (ICellGuiHandler ch : this.guiHandlers) {
            if (!ch.isHandlerFor(channel)) continue;
            if (ch.isSpecializedFor(is)) {
                return ch;
            }
            if (fallBack != null) continue;
            fallBack = ch;
        }
        return fallBack;
    }
}

