/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEPartLocation;
import appeng.client.render.effects.EnergyParticleData;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2498;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;

public class BlockTransitionEffectPacket
extends BasePacket {
    private final class_2338 pos;
    private final class_2680 blockState;
    private final AEPartLocation direction;
    private final SoundMode soundMode;

    public BlockTransitionEffectPacket(class_2338 pos, class_2680 blockState, AEPartLocation direction, SoundMode soundMode) {
        this.pos = pos;
        this.blockState = blockState;
        this.direction = direction;
        this.soundMode = soundMode;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.method_10807(pos);
        int blockStateId = class_2248.method_9507((class_2680)blockState);
        if (blockStateId == -1) {
            AELog.warn("Failed to find numeric id for block state %s", blockState);
        }
        data.writeInt(blockStateId);
        data.writeByte(this.direction.ordinal());
        data.writeByte((int)((byte)soundMode.ordinal()));
        this.configureWrite(data);
    }

    public BlockTransitionEffectPacket(class_2540 stream) {
        this.pos = stream.method_10811();
        int blockStateId = stream.readInt();
        class_2680 blockState = class_2248.method_9531((int)blockStateId);
        if (blockState == null) {
            AELog.warn("Received invalid blockstate id %d from server", blockStateId);
            blockState = class_2246.field_10124.method_9564();
        }
        this.blockState = blockState;
        this.direction = AEPartLocation.fromOrdinal(stream.readByte());
        this.soundMode = SoundMode.values()[stream.readByte()];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientPacketData(INetworkInfo network, class_1657 player) {
        this.spawnParticles();
        this.playBreakOrPickupSound();
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnParticles() {
        EnergyParticleData data = new EnergyParticleData(false, this.direction);
        for (int zz = 0; zz < 32; ++zz) {
            if (!AppEng.instance().shouldAddParticles(Platform.getRandom())) continue;
            double x = (float)this.pos.method_10263() + Platform.getRandomFloat();
            double y = (float)this.pos.method_10264() + Platform.getRandomFloat();
            double z = (float)this.pos.method_10260() + Platform.getRandomFloat();
            double speedX = 0.1f * (float)this.direction.xOffset;
            double speedY = 0.1f * (float)this.direction.yOffset;
            double speedZ = 0.1f * (float)this.direction.zOffset;
            class_310.method_1551().field_1713.method_3056((class_2394)data, x, y, z, speedX, speedY, speedZ);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void playBreakOrPickupSound() {
        float pitch;
        float volume;
        class_3414 soundEvent;
        if (this.soundMode == SoundMode.FLUID) {
            class_3611 rawFluid = this.blockState.method_26227().method_15772();
            soundEvent = rawFluid.method_15791((class_3494)class_3486.field_15518) ? class_3417.field_15202 : class_3417.field_15126;
            volume = 1.0f;
            pitch = 1.0f;
        } else if (this.soundMode == SoundMode.BLOCK) {
            class_2498 soundType = this.blockState.method_26231();
            soundEvent = soundType.method_10595();
            volume = soundType.field_11540;
            pitch = soundType.field_11539;
        } else {
            return;
        }
        class_1109 sound = new class_1109(soundEvent, class_3419.field_15245, (volume + 1.0f) / 2.0f, pitch * 0.8f, this.pos);
        class_310.method_1551().method_1483().method_4873((class_1113)sound);
    }

    public static enum SoundMode {
        BLOCK,
        FLUID,
        NONE;

    }
}

