/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.block.networking.CableBusBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.NetworkToolContainer;
import appeng.core.Api;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.NetworkToolItem;
import appeng.items.tools.powered.ColorApplicatorItem;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3965;

public class ClickPacket
extends BasePacket {
    private final int x;
    private final int y;
    private final int z;
    private class_2350 side;
    private final float hitX;
    private final float hitY;
    private final float hitZ;
    private class_1268 hand;
    private final boolean leftClick;

    public ClickPacket(class_2540 stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        byte side = stream.readByte();
        this.side = side != -1 ? class_2350.values()[side] : null;
        this.hitX = stream.readFloat();
        this.hitY = stream.readFloat();
        this.hitZ = stream.readFloat();
        this.hand = class_1268.values()[stream.readByte()];
        this.leftClick = stream.readBoolean();
    }

    public ClickPacket(class_1838 context) {
        this(context.method_8037(), context.method_8038(), context.method_8037().method_10263(), context.method_8037().method_10264(), context.method_8037().method_10260(), context.method_20287());
    }

    public ClickPacket(class_1268 hand) {
        this(class_2338.field_10980, null, 0.0f, 0.0f, 0.0f, hand);
    }

    private ClickPacket(class_2338 pos, class_2350 side, float hitX, float hitY, float hitZ, class_1268 hand) {
        this(pos, side, hitX, hitY, hitZ, hand, false);
    }

    public ClickPacket(class_2338 pos, class_2350 side, float hitX, float hitY, float hitZ, class_1268 hand, boolean leftClick) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.x = pos.method_10263();
        data.writeInt(this.x);
        this.y = pos.method_10264();
        data.writeInt(this.y);
        this.z = pos.method_10260();
        data.writeInt(this.z);
        if (side == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(side.ordinal());
        }
        this.hitX = hitX;
        data.writeFloat(this.hitX);
        this.hitY = hitY;
        data.writeFloat(this.hitY);
        this.hitZ = hitZ;
        data.writeFloat(this.hitZ);
        data.writeByte(hand.ordinal());
        this.leftClick = leftClick;
        data.writeBoolean(this.leftClick);
        this.configureWrite(data);
    }

    private boolean hasBlockContext() {
        return this.side != null;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_1657 player) {
        class_2338 pos = new class_2338(this.x, this.y, this.z);
        class_1799 is = player.method_5998(this.hand);
        IItems items = Api.instance().definitions().items();
        IItemDefinition maybeMemoryCard = items.memoryCard();
        IItemDefinition maybeColorApplicator = items.colorApplicator();
        if (this.leftClick) {
            class_2248 block = player.field_6002.method_8320(pos).method_26204();
            if (block instanceof CableBusBlock) {
                ((CableBusBlock)block).onBlockClickPacket(player.field_6002, pos, player, this.hand, new class_243((double)this.hitX, (double)this.hitY, (double)this.hitZ));
            }
        } else if (!is.method_7960()) {
            Object mem;
            if (is.method_7909() instanceof NetworkToolItem) {
                NetworkToolItem tnt = (NetworkToolItem)is.method_7909();
                if (this.hasBlockContext()) {
                    class_1838 useContext = new class_1838(player, this.hand, new class_3965(new class_243((double)this.hitX, (double)this.hitY, (double)this.hitZ), this.side, pos, false));
                    tnt.serverSideToolLogic(useContext);
                } else {
                    ContainerOpener.openContainer(NetworkToolContainer.TYPE, player, ContainerLocator.forHand(player, this.hand));
                }
            }
            if (maybeMemoryCard.isSameAs(is)) {
                mem = (IMemoryCard)is.method_7909();
                mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
                is.method_7980(null);
            } else if (maybeColorApplicator.isSameAs(is)) {
                mem = (ColorApplicatorItem)is.method_7909();
                ((ColorApplicatorItem)mem).cycleColors(is, ((ColorApplicatorItem)mem).getColor(is), 1);
            }
        }
    }
}

