/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.EnumCycler;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public final class ConfigButtonPacket
extends BasePacket {
    private final Settings option;
    private final boolean rotationDirection;

    public ConfigButtonPacket(class_2540 stream) {
        this.option = Settings.values()[stream.readInt()];
        this.rotationDirection = stream.readBoolean();
    }

    public ConfigButtonPacket(Settings option, boolean rotationDirection) {
        this.option = option;
        this.rotationDirection = rotationDirection;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(option.ordinal());
        data.writeBoolean(rotationDirection);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_1657 player) {
        AEBaseContainer baseContainer;
        class_3222 sender = (class_3222)player;
        if (sender.field_7512 instanceof AEBaseContainer && (baseContainer = (AEBaseContainer)sender.field_7512).getTarget() instanceof IConfigurableObject) {
            IConfigManager cm = ((IConfigurableObject)baseContainer.getTarget()).getConfigManager();
            Enum<?> setting = cm.getSetting(this.option);
            Enum<?> newState = EnumCycler.rotateEnum(setting, this.rotationDirection, this.option.getPossibleValues());
            cm.putSetting(this.option, newState);
        }
    }
}

