/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.IActionHost;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.CraftAmountContainer;
import appeng.container.implementations.CraftConfirmContainer;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Future;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public class CraftRequestPacket
extends BasePacket {
    private final long amount;
    private final boolean heldShift;

    public CraftRequestPacket(class_2540 stream) {
        this.heldShift = stream.readBoolean();
        this.amount = stream.readLong();
    }

    public CraftRequestPacket(int craftAmt, boolean shift) {
        this.amount = craftAmt;
        this.heldShift = shift;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        data.writeLong(this.amount);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_1657 player) {
        CraftAmountContainer cca;
        Object target;
        if (player.field_7512 instanceof CraftAmountContainer && (target = (cca = (CraftAmountContainer)player.field_7512).getTarget()) instanceof IActionHost) {
            IActionHost ah = (IActionHost)target;
            IGridNode gn = ah.getActionableNode();
            if (gn == null) {
                return;
            }
            IGrid g = gn.getGrid();
            if (g == null || cca.getItemToCraft() == null) {
                return;
            }
            cca.getItemToCraft().setStackSize(this.amount);
            Future<ICraftingJob> futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                ContainerLocator locator = cca.getLocator();
                if (locator != null) {
                    ContainerOpener.openContainer(CraftConfirmContainer.TYPE, player, locator);
                    if (player.field_7512 instanceof CraftConfirmContainer) {
                        CraftConfirmContainer ccc = (CraftConfirmContainer)player.field_7512;
                        ccc.setAutoStart(this.heldShift);
                        ccc.setJob(futureJob);
                        cca.method_7623();
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.info(e);
            }
        }
    }
}

