/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class FluidSlotPacket
extends BasePacket {
    private final Map<Integer, IAEFluidStack> list;

    public FluidSlotPacket(class_2540 stream) {
        this.list = new HashMap<Integer, IAEFluidStack>();
        class_2487 tag = stream.method_10798();
        for (String key : tag.method_10541()) {
            this.list.put(Integer.parseInt(key), AEFluidStack.fromNBT(tag.method_10562(key)));
        }
    }

    public FluidSlotPacket(Map<Integer, IAEFluidStack> list) {
        this.list = list;
        class_2487 sendTag = new class_2487();
        for (Map.Entry<Integer, IAEFluidStack> fs : list.entrySet()) {
            class_2487 tag = new class_2487();
            if (fs.getValue() != null) {
                fs.getValue().writeToNBT(tag);
            }
            sendTag.method_10566(fs.getKey().toString(), (class_2520)tag);
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.method_10794(sendTag);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo manager, class_1657 player) {
        class_1703 c = player.field_7512;
        if (c instanceof IFluidSyncContainer) {
            ((IFluidSyncContainer)c).receiveFluidSlots(this.list);
        }
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_1657 player) {
        class_1703 c = player.field_7512;
        if (c instanceof IFluidSyncContainer) {
            ((IFluidSyncContainer)c).receiveFluidSlots(this.list);
        }
    }
}

