/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.CraftAmountContainer;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class InventoryActionPacket
extends BasePacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final IAEItemStack slotItem;

    public InventoryActionPacket(class_2540 stream) {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        boolean hasItem = stream.readBoolean();
        this.slotItem = hasItem ? AEItemStack.fromPacket(stream) : null;
    }

    public InventoryActionPacket(InventoryAction action, int slot, IAEItemStack slotItem) {
        if (Platform.isClient()) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    public InventoryActionPacket(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.writeBoolean(false);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_1657 player) {
        class_3222 sender = (class_3222)player;
        if (sender.field_7512 instanceof AEBaseContainer) {
            AEBaseContainer baseContainer = (AEBaseContainer)sender.field_7512;
            if (this.action == InventoryAction.AUTO_CRAFT) {
                ContainerLocator locator = baseContainer.getLocator();
                if (locator != null) {
                    ContainerOpener.openContainer(CraftAmountContainer.TYPE, player, locator);
                    if (sender.field_7512 instanceof CraftAmountContainer) {
                        CraftAmountContainer cca = (CraftAmountContainer)sender.field_7512;
                        if (baseContainer.getTargetStack() != null) {
                            cca.getCraftingItem().method_7673(baseContainer.getTargetStack().asItemStackRepresentation());
                            cca.setItemToCraft(baseContainer.getTargetStack());
                        }
                        cca.method_7623();
                    }
                }
            } else {
                baseContainer.doAction(sender, this.action, this.slot, this.id);
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, class_1657 player) {
        if (this.action == InventoryAction.UPDATE_HAND) {
            if (this.slotItem != null) {
                player.field_7514.method_7396(this.slotItem.createItemStack());
            } else {
                player.field_7514.method_7396(class_1799.field_8037);
            }
        }
    }
}

