/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.implementations.PatternTermContainer;
import appeng.core.Api;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.mixins.IngredientAccessor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class JEIRecipePacket
extends BasePacket {
    private static final int INLINE_RECIPE_NONE = 1;
    private static final int INLINE_RECIPE_SHAPED = 2;
    private class_2960 recipeId;
    @Nullable
    private class_1860<?> recipe;
    private boolean crafting;

    public JEIRecipePacket(class_2540 stream) {
        this.crafting = stream.readBoolean();
        String id = stream.method_10800(Short.MAX_VALUE);
        this.recipeId = new class_2960(id);
        int inlineRecipeType = stream.method_10816();
        switch (inlineRecipeType) {
            case 1: {
                break;
            }
            case 2: {
                this.recipe = class_1865.field_9035.method_8122(this.recipeId, stream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid inline recipe type.");
            }
        }
    }

    public JEIRecipePacket(class_2960 recipeId, boolean crafting) {
        class_2540 data = this.createCommonHeader(recipeId, crafting, 1);
        this.configureWrite(data);
    }

    public JEIRecipePacket(class_1869 recipe, boolean crafting) {
        class_2540 data = this.createCommonHeader(recipe.method_8114(), crafting, 2);
        class_1865.field_9035.method_8124(data, (class_1860)recipe);
        this.configureWrite(data);
    }

    private class_2540 createCommonHeader(class_2960 recipeId, boolean crafting, int inlineRecipeType) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(crafting);
        data.method_10812(recipeId);
        data.method_10804(inlineRecipeType);
        return data;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_1657 player) {
        class_3222 pmp = (class_3222)player;
        class_1703 con = pmp.field_7512;
        Preconditions.checkArgument((boolean)(con instanceof IContainerCraftingPacket));
        class_1860<?> recipe = player.method_5770().method_8433().method_8130(this.recipeId).orElse(null);
        if (recipe == null && this.recipe != null) {
            recipe = this.recipe;
        }
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0);
        IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
        IGridNode node = cct.getNetworkNode();
        Preconditions.checkArgument((node != null ? 1 : 0) != 0);
        IGrid grid = node.getGrid();
        Preconditions.checkArgument((grid != null ? 1 : 0) != 0);
        IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
        Preconditions.checkArgument((inv != null ? 1 : 0) != 0);
        ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        Preconditions.checkArgument((security != null ? 1 : 0) != 0);
        IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        FixedItemInv craftMatrix = cct.getInventoryByName("crafting");
        FixedItemInv playerInventory = cct.getInventoryByName("player");
        IMEMonitor<IAEItemStack> storage = inv.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        IPartitionList<IAEItemStack> filter = ViewCellItem.createFilter(cct.getViewCells());
        class_2371<class_1856> ingredients = this.ensure3by3CraftingMatrix(recipe);
        for (int x = 0; x < craftMatrix.getSlotCount(); ++x) {
            class_1799 newItem;
            class_1799 currentItem = craftMatrix.getInvStack(x);
            class_1856 ingredient = (class_1856)ingredients.get(x);
            if (!currentItem.method_7960() && (newItem = this.canUseInSlot(ingredient, currentItem)) != currentItem && security.hasPermission(player, SecurityPermissions.INJECT)) {
                AEItemStack in = AEItemStack.fromItemStack(currentItem);
                IAEItemStack out = cct.useRealItems() ? (IAEItemStack)Platform.poweredInsert(energy, storage, in, cct.getActionSource()) : null;
                currentItem = out != null ? out.createItemStack() : class_1799.field_8037;
            }
            if (currentItem.method_7960() && security.hasPermission(player, SecurityPermissions.EXTRACT)) {
                IAEItemStack out;
                if (cct.useRealItems()) {
                    IAEItemStack request = this.findBestMatchingItemStack(ingredient, filter, storage, cct);
                    out = request != null ? Platform.poweredExtraction(energy, storage, request.setStackSize(1L), cct.getActionSource()) : null;
                } else {
                    out = this.findBestMatchingPattern(ingredient, filter, crafting, storage, cct);
                    if (out == null) {
                        out = this.findBestMatchingItemStack(ingredient, filter, storage, cct);
                    }
                    if (out == null && JEIRecipePacket.getMatchingStacks(ingredient).length > 0) {
                        out = AEItemStack.fromItemStack(JEIRecipePacket.getMatchingStacks(ingredient)[0]);
                    }
                }
                if (out != null) {
                    currentItem = out.createItemStack();
                }
            }
            if (currentItem.method_7960()) {
                class_1799[] matchingStacks;
                for (class_1799 matchingStack : matchingStacks = JEIRecipePacket.getMatchingStacks(ingredient)) {
                    if (!currentItem.method_7960()) continue;
                    AdaptorFixedInv ad = new AdaptorFixedInv(playerInventory);
                    currentItem = cct.useRealItems() ? ad.removeItems(1, matchingStack, null) : ad.simulateRemove(1, matchingStack, null);
                }
            }
            ItemHandlerUtil.setStackInSlot(craftMatrix, x, currentItem);
        }
        if (!this.crafting) {
            this.handleProcessing(con, cct, recipe);
        }
        con.method_7609((class_1263)new WrapperInvItemHandler(craftMatrix));
    }

    private static class_1799[] getMatchingStacks(class_1856 ingredient) {
        IngredientAccessor accessor = (IngredientAccessor)ingredient;
        accessor.appeng_cacheMatchingStacks();
        if (ingredient.method_8103()) {
            return new class_1799[0];
        }
        class_1799[] stacks = accessor.getMatchingStacks();
        if (stacks.length == 1 && stacks[0].method_7960()) {
            return new class_1799[0];
        }
        return stacks;
    }

    private class_2371<class_1856> ensure3by3CraftingMatrix(class_1860<?> recipe) {
        class_2371 ingredients = recipe.method_8117();
        class_2371 expandedIngredients = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            int width = shapedRecipe.method_8150();
            int height = shapedRecipe.method_8158();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    class_1856 i = (class_1856)ingredients.get(source);
                    expandedIngredients.set(target, (Object)i);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                expandedIngredients.set(i, ingredients.get(i));
            }
        }
        return expandedIngredients;
    }

    private class_1799 canUseInSlot(class_1856 ingredient, class_1799 is) {
        return Arrays.stream(JEIRecipePacket.getMatchingStacks(ingredient)).filter(p -> p.method_7929(is)).findFirst().orElse(class_1799.field_8037);
    }

    private IAEItemStack findBestMatchingItemStack(class_1856 ingredients, IPartitionList<IAEItemStack> filter, IMEMonitor<IAEItemStack> storage, IContainerCraftingPacket cct) {
        Stream<AEItemStack> stacks = Arrays.stream(JEIRecipePacket.getMatchingStacks(ingredients)).map(AEItemStack::fromItemStack).filter(r -> r != null && (filter == null || filter.isListed((IAEItemStack)r)));
        return JEIRecipePacket.getMostStored(stacks, storage, cct);
    }

    private IAEItemStack findBestMatchingPattern(class_1856 ingredients, IPartitionList<IAEItemStack> filter, ICraftingGrid crafting, IMEMonitor<IAEItemStack> storage, IContainerCraftingPacket cct) {
        Stream<IAEItemStack> stacks = Arrays.stream(JEIRecipePacket.getMatchingStacks(ingredients)).map(AEItemStack::fromItemStack).filter(r -> r != null && (filter == null || filter.isListed((IAEItemStack)r))).map(s -> (IAEItemStack)s.setCraftable(!crafting.getCraftingFor((IAEItemStack)s, null, 0, null).isEmpty())).filter(IAEStack::isCraftable);
        return JEIRecipePacket.getMostStored(stacks, storage, cct);
    }

    private static IAEItemStack getMostStored(Stream<? extends IAEItemStack> stacks, IMEMonitor<IAEItemStack> storage, IContainerCraftingPacket cct) {
        return stacks.map(s -> {
            IAEItemStack stored = (IAEItemStack)storage.extractItems((IAEItemStack)s.copy().setStackSize(Long.MAX_VALUE), Actionable.SIMULATE, cct.getActionSource());
            return Pair.of((Object)s, (Object)(stored != null ? stored.getStackSize() : 0L));
        }).min((left, right) -> Long.compare((Long)right.getSecond(), (Long)left.getSecond())).map(Pair::getFirst).orElse(null);
    }

    private void handleProcessing(class_1703 con, IContainerCraftingPacket cct, class_1860<?> recipe) {
        if (con instanceof PatternTermContainer) {
            PatternTermContainer patternTerm = (PatternTermContainer)con;
            if (!patternTerm.craftingMode) {
                FixedItemInv output = cct.getInventoryByName("output");
                ItemHandlerUtil.setStackInSlot(output, 0, recipe.method_8110());
                ItemHandlerUtil.setStackInSlot(output, 1, class_1799.field_8037);
                ItemHandlerUtil.setStackInSlot(output, 2, class_1799.field_8037);
            }
        }
    }
}

