/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.fluids.client.gui.FluidTerminalScreen;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class MEFluidInventoryUpdatePacket
extends BasePacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    private static final int OPERATION_BYTE_LIMIT = 2048;
    @Nullable
    private final List<IAEFluidStack> list;
    private final byte ref;
    @Nullable
    private final class_2540 data;
    private int writtenBytes = 0;
    private boolean empty = true;

    public MEFluidInventoryUpdatePacket(class_2540 stream) {
        this.data = null;
        this.list = new LinkedList<IAEFluidStack>();
        this.ref = stream.readByte();
        while (stream.readableBytes() > 0) {
            this.list.add(AEFluidStack.fromPacket(stream));
        }
        this.empty = this.list.isEmpty();
    }

    public MEFluidInventoryUpdatePacket() throws IOException {
        this(0);
    }

    public MEFluidInventoryUpdatePacket(byte ref) throws IOException {
        this.ref = ref;
        this.data = new class_2540(Unpooled.buffer((int)2048));
        this.data.writeInt(this.getPacketID());
        this.data.writeByte((int)this.ref);
        this.list = null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientPacketData(INetworkInfo network, class_1657 player) {
        class_437 gs = class_310.method_1551().field_1755;
        if (gs instanceof FluidTerminalScreen) {
            ((FluidTerminalScreen)gs).postUpdate(this.list);
        }
    }

    @Override
    @Nullable
    public class_2596<?> toPacket(class_2598 direction) {
        this.configureWrite(this.data);
        return super.toPacket(direction);
    }

    public void appendFluid(IAEFluidStack fs) throws IOException, BufferOverflowException {
        class_2540 tmp = new class_2540(Unpooled.buffer((int)2048));
        fs.writeToPacket(tmp);
        if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
            throw new BufferOverflowException();
        }
        this.writtenBytes += tmp.readableBytes();
        this.data.writeBytes(tmp.array(), 0, tmp.readableBytes());
        this.empty = false;
    }

    public int getLength() {
        return this.data.readableBytes();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

