/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEColor;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.hooks.TickHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public class PaintedEntityPacket
extends BasePacket {
    private final AEColor myColor;
    private final int entityId;
    private int ticks;

    public PaintedEntityPacket(class_2540 stream) {
        this.entityId = stream.readInt();
        this.myColor = AEColor.values()[stream.readByte()];
        this.ticks = stream.readInt();
    }

    public PaintedEntityPacket(int myEntity, AEColor myColor, int ticksLeft) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.entityId = myEntity;
        data.writeInt(this.entityId);
        this.myColor = myColor;
        data.writeByte(this.myColor.ordinal());
        data.writeInt(ticksLeft);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo network, class_1657 player) {
        TickHandler.PlayerColor pc = new TickHandler.PlayerColor(this.entityId, this.myColor, this.ticks);
        TickHandler.instance().getPlayerColors().put(this.entityId, pc);
    }
}

