/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.PatternTermContainer;
import appeng.core.Api;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class PatternSlotPacket
extends BasePacket {
    public final IAEItemStack slotItem;
    public final IAEItemStack[] pattern = new IAEItemStack[9];
    public final boolean shift;

    public PatternSlotPacket(class_2540 stream) {
        this.shift = stream.readBoolean();
        this.slotItem = this.readItem(stream);
        for (int x = 0; x < 9; ++x) {
            this.pattern[x] = this.readItem(stream);
        }
    }

    private IAEItemStack readItem(class_2540 stream) {
        boolean hasItem = stream.readBoolean();
        if (hasItem) {
            return AEItemStack.fromPacket(stream);
        }
        return null;
    }

    public PatternSlotPacket(FixedItemInv pat, IAEItemStack slotItem, boolean shift) {
        this.slotItem = slotItem;
        this.shift = shift;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        this.writeItem(slotItem, data);
        for (int x = 0; x < 9; ++x) {
            this.pattern[x] = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(pat.getInvStack(x));
            this.writeItem(this.pattern[x], data);
        }
        this.configureWrite(data);
    }

    private void writeItem(IAEItemStack slotItem, class_2540 data) {
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_1657 player) {
        class_3222 sender = (class_3222)player;
        if (sender.field_7512 instanceof PatternTermContainer) {
            PatternTermContainer patternTerminal = (PatternTermContainer)sender.field_7512;
            patternTerminal.craftOrGetItem(this);
        }
    }
}

